package de.ugoe.cs.quest.plugin.mfc.eventcore;

import org.junit.*;

import de.ugoe.cs.quest.plugin.mfc.eventcore.MFCTargetComparator;
import de.ugoe.cs.quest.plugin.mfc.eventcore.WindowsEvent;

import static org.junit.Assert.*;

/**
 * The class <code>WindowsEventTest</code> contains tests for the class <code>{@link WindowsEvent}</code>.
 *
 * @author Steffen Herbold
 * @version 1.0
 */
public class WindowsEventTest {
	
	@Test
	public void testTargetEquals_1() throws Exception {
		WindowsEvent event = new WindowsEvent("type");
		String target1 = "<window name=\"name1\" class=\"class1\" resourceId=\"id1\" isModal=\"modal1\" hwnd=\"111\"/>";
		String target2 = "<window name=\"name1\" class=\"class1\" resourceId=\"id1\" isModal=\"modal1\" hwnd=\"111\"/>";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testTargetEquals_2() throws Exception {
		WindowsEvent event = new WindowsEvent("type");
		String target1 = "<window name=\"Messplatz\" class=\"#32770\" resourceId=\"0\" isModal=\"true\" hwnd=\"1770138\"/><window name=\"Messplatz im Einstellmodus\" class=\"#32770\" resourceId=\"0\" isModal=\"true\" hwnd=\"2032262\"/><window name=\"\" class=\"#32770\" resourceId=\"0\" isModal=\"false\" hwnd=\"459658\"/><window name=\"\" class=\"SysTabControl32\" resourceId=\"12320\" isModal=\"false\" hwnd=\"983734\"/>";
		String target2 = "<window name=\"Messplatz\" class=\"#32770\" resourceId=\"0\" isModal=\"true\" hwnd=\"1770138\"/><window name=\"Messplatz im Einstellmodus\" class=\"#32770\" resourceId=\"0\" isModal=\"true\" hwnd=\"2032262\"/><window name=\"\" class=\"#32770\" resourceId=\"0\" isModal=\"false\" hwnd=\"459658\"/><window name=\"\" class=\"SysTabControl32\" resourceId=\"12320\" isModal=\"false\" hwnd=\"983734\"/>";
		event.setTarget(target1);
		boolean expected = true;
		
		boolean result = event.targetEquals(target2);
		
		assertEquals(expected, result);
		
		MFCTargetComparator.setMutable(false);
		
		result = event.targetEquals(target2);
		
		assertEquals(expected, result);
	}

}
