package de.ugoe.cs.quest.eventcore.mock;

import de.ugoe.cs.quest.eventcore.IReplayable;

public class MockReplayable implements IReplayable {

	private static final long serialVersionUID = 1L;

	final String replay;
	final String target;

	public MockReplayable(String replay, String target) {
		this.replay = replay;
		this.target = target;
	}

	@Override
	public String getReplay() {
		return replay;
	}

	@Override
	public String getTarget() {
		return target;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (other instanceof MockReplayable) {
			if (replay != null && target != null) {
				return replay.equals(((MockReplayable) other).replay)
						&& target.equals(((MockReplayable) other).target);
			} else if (replay != null && target == null) {
				return replay.equals(((MockReplayable) other).replay)
						&& ((MockReplayable) other).target == null;
			} else if (replay == null && target != null) {
				return ((MockReplayable) other).replay == null
						&& target.equals(((MockReplayable) other).target);
			} else {
				return ((MockReplayable) other).replay == null
						&& ((MockReplayable) other).target == null;
			}
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		int hashCode = 17;
		if( replay!=null ) {
			hashCode *= replay.hashCode();
		}
		if( target!=null ) {
			hashCode *= target.hashCode();
		}
		return hashCode;
	}
}