package de.ugoe.cs.quest.assertions;

import org.junit.*;

import de.ugoe.cs.quest.assertions.TextEqualsReplay;
import static org.junit.Assert.*;

/**
 * The class <code>TextEqualsReplayTest</code> contains tests for the class
 * <code>{@link TextEqualsReplay}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class TextEqualsReplayTest {

	private final static String ENDLINE = System.getProperty("line.separator");

	@Test
	public void testTextEqualsReplay_1() throws Exception {
		String expectedValue = "expectedValueString";
		String target = "targetString";

		TextEqualsReplay result = new TextEqualsReplay(expectedValue, target);

		assertNotNull(result);
		assertEquals(expectedValue, result.expectedValue);
		assertEquals(target, result.target);
	}

	@Test
	public void testTextEqualsReplay_2() throws Exception {
		String target = "targetString";

		TextEqualsReplay result = new TextEqualsReplay(null, target);

		assertNotNull(result);
		assertEquals(null, result.expectedValue);
		assertEquals(target, result.target);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testTextEqualsReplay_3() throws Exception {
		String expectedValue = "expectedValueString";

		new TextEqualsReplay(expectedValue, null);
	}

	@Test
	public void testGetReplay_1() throws Exception {
		TextEqualsReplay fixture = new TextEqualsReplay("", "");

		String result = fixture.getReplay();

		assertEquals(" <textEquals expectedValue=\"\">" + ENDLINE + "<target>"
				+ ENDLINE + ENDLINE + "</target>" + ENDLINE + "</textEquals>"
				+ ENDLINE, result);
	}

	@Test
	public void testGetReplay_2() throws Exception {
		TextEqualsReplay fixture = new TextEqualsReplay("expectedValueString",
				"targetString");

		String result = fixture.getReplay();

		assertEquals(" <textEquals expectedValue=\"expectedValueString\">"
				+ ENDLINE + "<target>" + ENDLINE + "targetString" + ENDLINE
				+ "</target>" + ENDLINE + "</textEquals>" + ENDLINE, result);
	}

	@Test
	public void testGetTarget_1() throws Exception {
		TextEqualsReplay fixture = new TextEqualsReplay("expectedValueString",
				"targetString");

		String result = fixture.getTarget();

		assertEquals("targetString", result);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(TextEqualsReplayTest.class);
	}
}