package de.ugoe.cs.quest.plugin;

import java.io.File;

import junitx.framework.ArrayAssert;

import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>PluginLoaderTest</code> contains tests for the class
 * <code>{@link PluginLoader}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class PluginLoaderTest {
	
	@Test
	public void testPluginLoader_1() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		assertNotNull(loader);
	}
	
	@Test(expected = java.security.InvalidParameterException.class)
	public void testPluginLoader_2() throws Exception {
		new PluginLoader(null);
	}
	
	@Test(expected = java.security.InvalidParameterException.class)
	public void testPluginLoader_3() throws Exception {
		new PluginLoader(new File("testdata/de.ugoe.cs.quest.plugin.PluginLoaderTest/jfcmonitor.jar"));
	}
		
	@Test
	public void testCheckNameConformity_1() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = "quest-plugin-jfc-1.0.jar";
		boolean expected = true;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testCheckNameConformity_2() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = "quest-plugin-jf-c-1.0.jar";
		boolean expected = false;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testCheckNameConformity_3() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = "quest-plugin-jfc.jar";
		boolean expected = false;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testCheckNameConformity_4() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = "quest-plugi-jfc-1.0.jar";
		boolean expected = false;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testCheckNameConformity_5() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = "quest-pluginjfc-1.0.jar";
		boolean expected = false;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testCheckNameConformity_6() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = "quest-plugin-jfc-1-0.jar";
		boolean expected = false;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testCheckNameConformity_7() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = "quest-plugin-jfc-1.0.nojar";
		boolean expected = false;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testCheckNameConformity_8() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = null;
		boolean expected = false;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testCheckNameConformity_9() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		String filename = "";
		boolean expected = false;
		
		boolean result = loader.checkNameConformity(filename);
		
		assertEquals(expected, result);
	}
	
	@Test
	public void testGetClassPathFromJar_1() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		File jarFile = new File("testdata/de.ugoe.cs.quest.plugin.PluginLoaderTest/jfcmonitor.jar");
		
		String[] expected = new String[]{ "file:" + jarFile.getParentFile().getAbsolutePath()+"/javahelperlib.jar" };
				
		String[] result = loader.getClassPathFromJar(jarFile);
		
		ArrayAssert.assertEquivalenceArrays(expected, result);
	}
	
	@Test
	public void testGetClassPathFromJar_2() throws Exception {
		PluginLoader loader = new PluginLoader(new File("."));
		File jarFile = new File("testdata/de.ugoe.cs.quest.plugin.PluginLoaderTest/jmi.jar");
		
		String[] expected = new String[]{ };
				
		String[] result = loader.getClassPathFromJar(jarFile);
		
		ArrayAssert.assertEquivalenceArrays(expected, result);
	}

}
