package de.ugoe.cs.quest.usageprofiles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.usageprofiles.DeterministicFiniteAutomaton;

import java.util.Random;
import org.junit.*;

import static org.junit.Assert.*;

/**
 * The class <code>DeterministicFiniteAutomatonTest</code> contains tests for
 * the class <code>{@link DeterministicFiniteAutomaton}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class DeterministicFiniteAutomatonTest {

	Collection<List<? extends Event<?>>> sequences;

	@Test
	public void testDeterministicFiniteAutomaton_1() throws Exception {
		Random r = new Random();

		DeterministicFiniteAutomaton result = new DeterministicFiniteAutomaton(
				r);

		assertNotNull(result);
		assertEquals(2, result.trieOrder);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testDeterministicFiniteAutomaton_2() throws Exception {
		new DeterministicFiniteAutomaton(null);
	}

	@Test
	public void testGetProbability_1() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event<String>> context = new ArrayList<Event<String>>();
		context.add(new Event<String>("a"));
		context.add(new Event<String>("b"));

		Event<String> symbol = new Event<String>("r");

		double result = fixture.getProbability(context, symbol);

		assertEquals(1.0d, result, 0.0001);
	}

	@Test
	public void testGetProbability_2() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event<String>> context = new ArrayList<Event<String>>();
		context.add(new Event<String>("a"));

		Event<String> symbol = new Event<String>("b");

		double result = fixture.getProbability(context, symbol);

		assertEquals(1.0d / 4.0, result, 0.0001);
	}

	@Test
	public void testGetProbability_3() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event<String>> context = new ArrayList<Event<String>>();
		context.add(new Event<String>("a"));

		Event<String> symbol = new Event<String>("c");

		double result = fixture.getProbability(context, symbol);

		assertEquals(1.0d / 4.0, result, 0.0001);
	}

	@Test
	public void testGetProbability_4() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event<String>> context = new ArrayList<Event<String>>();
		context.add(new Event<String>("a"));

		Event<String> symbol = new Event<String>("e");

		double result = fixture.getProbability(context, symbol);

		assertEquals(0.0d, result, 0.0001);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testGetProbability_5() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event<String>> context = new ArrayList<Event<String>>();
		context.add(new Event<String>("a"));

		Event<String> symbol = null;

		fixture.getProbability(context, symbol);
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testGetProbability_6() throws Exception {
		DeterministicFiniteAutomaton fixture = new DeterministicFiniteAutomaton(
				new Random());
		fixture.train(sequences);

		List<Event<String>> context = null;

		Event<String> symbol = new Event<String>("a");

		fixture.getProbability(context, symbol);
	}

	@Before
	public void setUp() throws Exception {
		List<Event<?>> sequence = new ArrayList<Event<?>>();
		sequence.add(new Event<String>("a"));
		sequence.add(new Event<String>("b"));
		sequence.add(new Event<String>("r"));
		sequence.add(new Event<String>("a"));
		sequence.add(new Event<String>("c"));
		sequence.add(new Event<String>("a"));
		sequence.add(new Event<String>("d"));
		sequence.add(new Event<String>("a"));
		sequence.add(new Event<String>("b"));
		sequence.add(new Event<String>("r"));
		sequence.add(new Event<String>("a"));

		sequences = new ArrayList<List<? extends Event<?>>>();
		sequences.add(sequence);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore()
				.run(DeterministicFiniteAutomatonTest.class);
	}
}