//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: ComponentManager.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 12.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.manager;

import de.ugoe.cs.quest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.quest.tasktrees.temporalrelation.TemporalRelationshipRuleManager;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilderImpl;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactoryImpl;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 12.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
// -------------------------------------------------------------------------------------------------
public class ComponentManager
{
  /** */
  private static ComponentManager sInstance;

  /** */
  private TemporalRelationshipRuleManager mTemporalRelationshipRuleManager;
  
  /** */
  private NodeEqualityRuleManager mNodeEqualityRuleManager;

  /** */
  private TaskTreeBuilder mTaskTreeBuilder;

  /** */
  private TaskTreeNodeFactory mTaskTreeNodeFactory;

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public static TemporalRelationshipRuleManager getTemporalRelationshipRuleManager()
  {
    return getInstance().mTemporalRelationshipRuleManager;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public static NodeEqualityRuleManager getNodeEqualityRuleManager()
  {
    return getInstance().mNodeEqualityRuleManager;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public static TaskTreeBuilder getDefaultTaskTreeBuilder()
  {
    return getInstance().mTaskTreeBuilder;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public static TaskTreeNodeFactory getDefaultTaskTreeNodeFactory()
  {
    return getInstance().mTaskTreeNodeFactory;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public static synchronized void clearInstance()
  {
    sInstance = null;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  private static synchronized ComponentManager getInstance()
  {
    if (sInstance == null)
    {
      sInstance = new ComponentManager();
      sInstance.init();
    }
    return sInstance;
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  private void init()
  {
    mNodeEqualityRuleManager = new NodeEqualityRuleManager();
    mNodeEqualityRuleManager.init();
    
    mTemporalRelationshipRuleManager =
      new TemporalRelationshipRuleManager(mNodeEqualityRuleManager);
    mTemporalRelationshipRuleManager.init();

    mTaskTreeBuilder = new TaskTreeBuilderImpl();
    mTaskTreeNodeFactory = new TaskTreeNodeFactoryImpl();
  }

}
