//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: NodeEqualityRuleManager.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 19.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.nodeequality;

import java.util.ArrayList;
import java.util.List;
//import java.util.logging.Logger;

import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 19.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class NodeEqualityRuleManager
{

  /** */
  //private static Logger LOG = Logger.getLogger(NodeEqualityRuleManager.class.getName());

  /** */
  private List<NodeComparisonRule> mRuleIndex = new ArrayList<NodeComparisonRule>();

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  public void init()
  {
    mRuleIndex.add(new NodeIdentityRule());
    mRuleIndex.add(new IterationComparisonRule(this));
    mRuleIndex.add(new SequenceComparisonRule(this));
    mRuleIndex.add(new SelectionComparisonRule(this));
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param node1
   * @param node2
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  public NodeEquality applyRules(TaskTreeNode node1, TaskTreeNode node2)
  {
    //LOG.info("checking for equality of " + node1 + " and " + node2);
    NodeEquality nodeEquality = null;
      
    for (NodeComparisonRule rule : mRuleIndex)
    {
      nodeEquality = rule.compare(node1, node2);
      
      if (nodeEquality != null)
      {
        //LOG.warning("used rule " + rule + " for equality check");
        return nodeEquality;
      }
    }
    
    //LOG.warning("no rule could be applied --> handling nodes as unequal");
    
    return new NodesUnequal();
  }

}
