//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: NodeIdentityRule.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 19.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.nodeequality;

import de.ugoe.cs.quest.tasktrees.treeifc.Sequence;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 19.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class SequenceComparisonRule implements NodeComparisonRule
{


  /** */
  private NodeEqualityRuleManager mRuleManager;

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   */
  //-----------------------------------------------------------------------------------------------
  SequenceComparisonRule(NodeEqualityRuleManager ruleManager)
  {
    super();
    mRuleManager = ruleManager;
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.nodeequality.NodeEqualityRule#apply(TaskTreeNode, TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public NodeEquality compare(TaskTreeNode node1, TaskTreeNode node2)
  {
    if ((!(node1 instanceof Sequence)) || (!(node2 instanceof Sequence)))
    {
      return null;
    }
    
    // if both sequences do not have children, they are equal although this doesn't make sense
    if ((node1.getChildren().size() == 0) && (node2.getChildren().size() == 0))
    {
      return new NodesEqual();
    }
    
    // Sequences are equal, if they have the same number and order of children. If all the
    // children match structurally, then the sequences are structurally equal. Otherwise, if
    // at least one pair of children matches only semantically, then the sequences match only
    // semantically.
    if (node1.getChildren().size() != node2.getChildren().size())
    {
      return null;
    }
    
    boolean structurallyEqual = true;
    for (int i = 0; i < node1.getChildren().size(); i++)
    {
      TaskTreeNode child1 = node1.getChildren().get(i);
      TaskTreeNode child2 = node2.getChildren().get(i);
      
      NodeEquality nodeEquality = mRuleManager.applyRules(child1, child2);
      
      structurallyEqual &= nodeEquality.getStructuralEquality();
      
      if (!structurallyEqual && !nodeEquality.getSemanticalEquality())
      {
        return null;
      }
    }
    
    if (structurallyEqual)
    {
      return new NodesEqual();
    }
    else
    {
      return new NodesSemanticallyEqual();
    }
  }

}
