//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: TaskTreeBuilderImpl.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 21.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.treeimpl;

import de.ugoe.cs.quest.tasktrees.treeifc.Iteration;
import de.ugoe.cs.quest.tasktrees.treeifc.Selection;
import de.ugoe.cs.quest.tasktrees.treeifc.Sequence;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.TaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.TextInputInteractionTask;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 21.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class TaskTreeBuilderImpl implements TaskTreeBuilder
{
  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Sequence, TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void addChild(Sequence parent, TaskTreeNode child)
  {
    if (!(parent instanceof SequenceImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + parent.getClass());
    }

    addChildInternal(parent, -1, child);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Sequence, int, TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void addChild(Sequence parent, int index, TaskTreeNode child)
  {
    if (!(parent instanceof SequenceImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + parent.getClass());
    }

    addChildInternal(parent, index, child);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(Selection, TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void addChild(Selection parent, TaskTreeNode child)
  {
    if (!(parent instanceof SelectionImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + parent.getClass());
    }

    addChildInternal(parent, -1, child);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#addChild(de.ugoe.cs.tasktree.treeifc.TextInputInteractionTask, de.ugoe.cs.tasktree.treeifc.TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void addChild(TextInputInteractionTask parent, TaskTreeNode child)
  {
    if (!(parent instanceof TextInputInteractionTaskImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + parent.getClass());
    }

    addChildInternal(parent, -1, child);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#setChild(Iteration, TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void setChild(Iteration iteration, TaskTreeNode newChild)
  {
    if (!(iteration instanceof IterationImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of iteration provided: " + iteration.getClass());
    }

    if (!(newChild instanceof TaskTreeNodeImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + newChild.getClass());
    }
    
    ((IterationImpl) iteration).setChild(determineNode(newChild));
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#removeChild(Sequence, int)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void removeChild(Sequence parent, int index)
  {
    if (!(parent instanceof TaskTreeNodeImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + parent.getClass());
    }

    ((TaskTreeNodeImpl) parent).removeChild(index);
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#removeChild(Selection, TaskTreeNode)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void removeChild(Selection parent, TaskTreeNode child)
  {
    if (!(parent instanceof TaskTreeNodeImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + parent.getClass());
    }

    for (int i = 0; i < parent.getChildren().size(); i++)
    {
      if ((parent.getChildren().get(i) == child) ||
          ((parent.getChildren().get(i) != null) && (parent.getChildren().get(i).equals(child))))
      {
        ((TaskTreeNodeImpl) parent).removeChild(i);
        break;
      }
    }
  }

  //-----------------------------------------------------------------------------------------------
  /* (non-Javadoc)
   * @see de.ugoe.cs.tasktree.treeifc.TaskTreeBuilder#setDescription(TaskTreeNode, String)
   */
  //-----------------------------------------------------------------------------------------------
  @Override
  public void setDescription(TaskTreeNode parent, String description)
  {
    if (!(parent instanceof TaskTreeNodeImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + parent.getClass());
    }

    ((TaskTreeNodeImpl) parent).setDescription(description);
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * 
   */
  //-----------------------------------------------------------------------------------------------
  private void addChildInternal(TaskTreeNode parent, int index, TaskTreeNode child)
  {
    if (!(child instanceof TaskTreeNodeImpl))
    {
      throw new IllegalArgumentException
        ("illegal type of task tree node provided: " + child.getClass());
    }
    
    if (index > -1)
    {
      ((TaskTreeNodeImpl) parent).addChild(index, determineNode(child));
    }
    else
    {
      ((TaskTreeNodeImpl) parent).addChild(determineNode(child));
    }
  }

  //-----------------------------------------------------------------------------------------------
  /**
   * TODO: comment
   *
   * @param newChild
   * @return
   */
  //-----------------------------------------------------------------------------------------------
  private TaskTreeNode determineNode(TaskTreeNode newNode)
  {
    return newNode;
    /*TaskTreeNode node = mTaskMap.get(newNode);
    if (node == null)
    {
      node = newNode;
      mTaskMap.put(node, node);
    }
    
    return node;*/
  }

}
