package de.ugoe.cs.quest.plugin.guitar;

import de.ugoe.cs.quest.IReplayDecorator;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * {@link IReplayDecorator} for replays generated for the GUITAR suite.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class EFGReplayDecorator implements IReplayDecorator {

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * The instance of the {@link EFGReplayDecorator} (implemented as
	 * singleton).
	 * </p>
	 */
	transient private static EFGReplayDecorator theInstance;

	/**
	 * <p>
	 * Constructor. Private to guarantee that only one instance of the replay
	 * generator exists.
	 * </p>
	 */
	private EFGReplayDecorator() {
	};

	/**
	 * <p>
	 * Returns the instance of the MFCReplayDecorator.
	 * </p>
	 * 
	 * @return instance of the MFCReplayDecorator.
	 */
	public static EFGReplayDecorator getInstance() {
		if (theInstance == null) {
			theInstance = new EFGReplayDecorator();
		}
		return theInstance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.IReplayDecorator#getHeader()
	 */
	@Override
	public String getHeader() {
		return "<?xml version=\"1.0\" encoding=\"UTF-16\"?>"
				+ StringTools.ENDLINE + "<TestCase>" + StringTools.ENDLINE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.IReplayDecorator#getFooter()
	 */
	@Override
	public String getFooter() {
		return "</TestCase>";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.IReplayDecorator#getSessionHeader(int)
	 */
	@Override
	public String getSessionHeader(int sessionId) {
		return "";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.IReplayDecorator#getSessionFooter(int)
	 */
	@Override
	public String getSessionFooter(int sessionId) {
		return "";
	}

}
