package de.ugoe.cs.quest.plugin.mfc.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.plugin.mfc.MFCLogParser;
import de.ugoe.cs.quest.plugin.mfc.eventcore.MFCTargetComparator;
import de.ugoe.cs.quest.plugin.mfc.eventcore.WindowTree;
import de.ugoe.cs.quest.plugin.mfc.eventcore.WindowsEvent;
import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to parse an XML file with sessions monitored by EventBench's
 * MFCUsageMonitor.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDparseXML implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: parseXML <filename> {<sequencesName>} {<countMessageOccurences>}");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String sequencesName = "sequences";
		boolean countMessageOccurences = false;

		try {
			filename = (String) parameters.get(0);
			if (parameters.size() >= 2) {
				sequencesName = (String) parameters.get(1);
			}
			if (parameters.size() >= 3) {
				countMessageOccurences = Boolean
						.parseBoolean((String) parameters.get(2));
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		MFCLogParser parser = new MFCLogParser(countMessageOccurences);
		parser.parseFile(filename);

		Collection<List<WindowsEvent>> sequences = parser.getSequences();
		
		Console.traceln("Pre-computing event target equalities.");
		// compare all Events to a dummy event to make sure they are known by
		// the MFCTargetComparator
		WindowsEvent dummyEvent = new WindowsEvent("dummy");
		for (List<WindowsEvent> sequence : sequences) {
			for (WindowsEvent event : sequence) {
				event.equals(dummyEvent);
			}
		}
		MFCTargetComparator.setMutable(false);
		
		SortedSet<String> targets = WindowTree.getInstance().getTargets();

		if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
			CommandHelpers.dataOverwritten(sequencesName);
		}
		if (GlobalDataContainer.getInstance().addData(
				sequencesName + "_targets", targets)) {
			CommandHelpers.dataOverwritten(sequencesName + "_targets");
		}
	}

}
