package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.ReplayGenerator;
import de.ugoe.cs.quest.SequenceInstanceOf;
import de.ugoe.cs.quest.eventcore.ReplayableEvent;
import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to create a replay file from stored sessions.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDgenerateReplayfile implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: generateReplayfile <filename> <sequences>");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String filename;
		String sequencesName;
		try {
			filename = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		Collection<List<ReplayableEvent<?>>> sequences = null;
		Object dataObject = GlobalDataContainer.getInstance().getData(
				sequencesName);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(sequencesName);
			return;
		}
		if (!SequenceInstanceOf.isCollectionOfSequences(dataObject)) {
			CommandHelpers.objectNotType(sequencesName,
					"Collection<List<Event<?>>>");
			return;
		}

		sequences = (Collection<List<ReplayableEvent<?>>>) dataObject;
		ReplayGenerator generator = new ReplayGenerator();
		generator.createLogfileMultipleSessions(sequences, filename);
	}

}
