package de.ugoe.cs.quest.ui;

import java.io.File;
import java.io.IOException;
import java.util.List;

import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import de.ugoe.cs.quest.log4j.Log4JLogger;
import de.ugoe.cs.quest.plugin.PluginLoader;
import de.ugoe.cs.quest.plugin.QuestPlugin;
import de.ugoe.cs.quest.ui.swt.MainWindow;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.TextConsole;

/**
 * <p>
 * Start-up class of the application.
 * </p>
 * <p>
 * It sets up and starts the {@link Console}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class Runner {

	public enum UITYPE {
		text, swt
	};

	public enum LOG4JTYPE {
		enable, disable
	}

	/**
	 * <p>
	 * Main method of the application.
	 * </p>
	 * 
	 * @param args
	 *            if parameters are defined, they are interpreted as commands
	 *            for the {@link Console} and executed before the user can use
	 *            the console; can be used to perform batch operations
	 */
	public static void main(String[] args) {

		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.quest.ui.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.quest.ui.swt.commands");

		// The following four command packages are added automatically, once the
		// plugin-mechanism works correctly. Hence, these calls should be
		// removed then.
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.quest.plugin.mfc.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.quest.plugin.php.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.quest.plugin.guitar.commands");
		CommandExecuter.getInstance().addCommandPackage(
				"de.ugoe.cs.quest.plugin.jfc.commands");

		/*
		 * Code for loading plugins. Should be uncommented once the
		 * plugin-mechanism works correctly.
		 * TODO: uncomment as soon as plug-in mechanism works
		 * 
		 * PluginLoader pluginLoader = new PluginLoader(new File("plugins"));
		 * pluginLoader.load();
		 * 
		 * for( QuestPlugin plugin : pluginLoader.getPlugins()) { for( String
		 * commandPackage : plugin.getCommandPackages()) {
		 * CommandExecuter.getInstance().addCommandPackage(commandPackage); } }
		 */

		OptionParser parser = new OptionParser();
		OptionSpec<LOG4JTYPE> log4j = parser
				.accepts("log4j", "Allowed values: enable, disable")
				.withRequiredArg().ofType(LOG4JTYPE.class)
				.defaultsTo(LOG4JTYPE.enable);
		OptionSpec<UITYPE> ui = parser
				.accepts("ui", "Allowed values: text, swt").withRequiredArg()
				.ofType(UITYPE.class).defaultsTo(UITYPE.text);
		OptionSpec<LOG4JTYPE> trace = parser
				.accepts("trace", "Allowed values: enable, disable")
				.withRequiredArg().ofType(LOG4JTYPE.class)
				.defaultsTo(LOG4JTYPE.enable);
		OptionSet options = parser.parse(args);

		List<String> startupCommands = options.nonOptionArguments();
		try {
			switch (options.valueOf(log4j)) {
			case enable:
				new Log4JLogger();
				break;
			case disable:
				// do nothing
				break;
			default:
				throw new AssertionError(
						"reached source code that should be unreachable");
			}

			switch (options.valueOf(ui)) {
			case text:
				TextConsole textConsole = new TextConsole();
				if (options.valueOf(trace) == LOG4JTYPE.disable) {
					textConsole.setDebug(false);
				}
				for (String command : startupCommands) {
					CommandExecuter.getInstance().exec(command);
				}
				textConsole.run(true);
				break;
			case swt:
				MainWindow mainWindow = new MainWindow(startupCommands);
				mainWindow.open();
				break;
			default:
				throw new AssertionError(
						"reached source code that should be unreachable");
			}
		} catch (OptionException e) {
			System.err.println("Invalid Parameters: " + e.getMessage());
			try {
				parser.printHelpOn(System.out);
			} catch (IOException e1) {
				// ignore exception.
			}
		}
	}

}
