package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.testgeneration.DrawFromAllSequencesGenerator;
import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.quest.usageprofiles.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to generate all sequences of a given length.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDgenerateFixedLengthSequences implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String sequencesName;
		int minLength;
		int maxLength;
		boolean all = true;
		int numSequences = -1;
		boolean validEnd = true;
		try {
			modelname = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
			minLength = Integer.parseInt((String) parameters.get(2));
			maxLength = Integer.parseInt((String) parameters.get(3));
			if (parameters.size() >= 5) {
				all = Boolean.parseBoolean((String) parameters.get(4));
			}
			if (parameters.size() >= 6) {
				numSequences = Integer.parseInt((String) parameters.get(5));
			}
			if (parameters.size() >= 7) {
				validEnd = Boolean.parseBoolean((String) parameters.get(6));
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		IStochasticProcess model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		} else if (!(dataObject instanceof IStochasticProcess)) {
			CommandHelpers.objectNotType(modelname, "IStochasticProcess");
			return;
		}
		model = (IStochasticProcess) dataObject;
		DrawFromAllSequencesGenerator generator = new DrawFromAllSequencesGenerator(
				numSequences, minLength, maxLength, validEnd, all);
		Collection<List<? extends Event<?>>> sequences = generator
				.generateTestSuite(model);

		if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
			CommandHelpers.dataOverwritten(sequencesName);
		}
		Console.println("" + sequences.size() + " sequences generated");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: generateFixedLengthSequences <modelname> <sequencesName> <minlenght> <maxlength> {<all>} {<numSequences>} {<validEnd>}");
	}

}
