//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: DefaultIterationDetectionRuleTest.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 28.04.2012 $
// Project   : TaskTreeTemporalRelationship
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.guimodel.GUIElement;
import de.ugoe.cs.quest.eventcore.userinteraction.Interaction;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class DefaultIterationDetectionRuleTest extends AbstractTemporalRelationshipTC
{

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testInteractionIterationDetection() throws Exception
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    Interaction interaction1 = new DummyInteraction("bla", 1);
    simulateInteraction(element1, interaction1);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Interaction bla {}" +
       "}", getTaskTree());    

    simulateInteraction(element1, interaction1);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", getTaskTree());    

    simulateInteraction(element1, interaction1);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", getTaskTree());    

    for (int i = 0; i < 10; i++)
    {
      simulateInteraction(element1, interaction1);
    }
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", getTaskTree());    
    
    // now test with preceding and trailing other interactions
    Interaction interaction2 = new DummyInteraction("bli", 1);
    Interaction interaction3 = new DummyInteraction("blup", 1);

    simulateInteraction(element1, interaction2);
    simulateInteraction(element1, interaction3);
    for (int i = 0; i < 10; i++)
    {
      simulateInteraction(element1, interaction1);
    }
    simulateInteraction(element1, interaction3);
    simulateInteraction(element1, interaction2);
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Interaction bli {}" +
       "  Interaction blup {}" +
       "  Iteration iteration2 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Interaction blup {}" +
       "  Interaction bli {}" +
       "}", getTaskTree());    
  
    // now test with iterations of iterations

    for (int i = 0; i < 10; i++)
    {
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction1);
      }
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction2);
      }
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction3);
      }
    }
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Interaction bli {}" +
       "  Interaction blup {}" +
       "  Iteration iteration2 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Interaction blup {}" +
       "  Interaction bli {}" +
       "  Iteration iteration3 {" +
       "    Sequence sequence2 {" +
       "      Iteration iteration4 {" +
       "        Interaction bla {}" +
       "      }" +
       "      Iteration iteration5 {" +
       "        Interaction bli {}" +
       "      }" +
       "      Iteration iteration6 {" +
       "        Interaction blup {}" +
       "      }" +
       "    }" +
       "  }" +
       "}", getTaskTree());    
  
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testSequenceIterationDetection() throws Exception
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    Interaction interaction1 = new DummyInteraction("bla", 1);
    Interaction interaction2 = new DummyInteraction("bli", 1);
    Interaction interaction3 = new DummyInteraction("blup", 1);
    simulateInteraction(element1, interaction1);
    simulateInteraction(element1, interaction2);
    simulateInteraction(element1, interaction3);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Interaction bla {}" +
       "  Interaction bli {}" +
       "  Interaction blup {}" +
       "}", getTaskTree());    

    simulateInteraction(element1, interaction1);
    simulateInteraction(element1, interaction2);
    simulateInteraction(element1, interaction3);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());    

    simulateInteraction(element1, interaction1);
    simulateInteraction(element1, interaction2);
    simulateInteraction(element1, interaction3);
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());    

    for (int i = 0; i < 10; i++)
    {
      simulateInteraction(element1, interaction1);
      simulateInteraction(element1, interaction2);
      simulateInteraction(element1, interaction3);
    }
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());    
    
    // now test with preceding and trailing other interactions
    Interaction interaction4 = new DummyInteraction("ble", 1);
    Interaction interaction5 = new DummyInteraction("blo", 1);
    Interaction interaction6 = new DummyInteraction("blu", 1);
    simulateInteraction(element1, interaction4);
    simulateInteraction(element1, interaction5);
    simulateInteraction(element1, interaction6);
    for (int i = 0; i < 10; i++)
    {
      simulateInteraction(element1, interaction1);
      simulateInteraction(element1, interaction2);
      simulateInteraction(element1, interaction3);
    }
    simulateInteraction(element1, interaction6);
    simulateInteraction(element1, interaction5);
    simulateInteraction(element1, interaction4);
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "  Interaction ble {}" +
       "  Interaction blo {}" +
       "  Interaction blu {}" +
       "  Iteration iteration2 {" +
       "    Sequence sequence3 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "  Interaction blu {}" +
       "  Interaction blo {}" +
       "  Interaction ble {}" +
       "}", getTaskTree());    
  
    // now test with iterations of iterations
    for (int i = 0; i < 10; i++)
    {
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction1);
        simulateInteraction(element1, interaction2);
        simulateInteraction(element1, interaction3);
      }
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction2);
        simulateInteraction(element1, interaction1);
        simulateInteraction(element1, interaction3);
      }
      for (int j = 0; j < 5; j++)
      {
        simulateInteraction(element1, interaction1);
        simulateInteraction(element1, interaction2);
        simulateInteraction(element1, interaction3);
      }
    }
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration iteration1 {" +
       "    Sequence sequence2 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "  Interaction ble {}" +
       "  Interaction blo {}" +
       "  Interaction blu {}" +
       "  Iteration iteration2 {" +
       "    Sequence sequence3 {" +
       "      Interaction bla {}" +
       "      Interaction bli {}" +
       "      Interaction blup {}" +
       "    }" +
       "  }" +
       "  Interaction blu {}" +
       "  Interaction blo {}" +
       "  Interaction ble {}" +
       "  Iteration iteration3 {" +
       "    Sequence sequence4 {" +
       "      Iteration iteration4 {" +
       "        Sequence sequence4 {" +
       "          Interaction bla {}" +
       "          Interaction bli {}" +
       "          Interaction blup {}" +
       "        }" +
       "      }" +
       "      Iteration iteration5 {" +
       "        Sequence sequence5 {" +
       "          Interaction bli {}" +
       "          Interaction bla {}" +
       "          Interaction blup {}" +
       "        }" +
       "      }" +
       "      Iteration iteration6 {" +
       "        Sequence sequence6 {" +
       "          Interaction bla {}" +
       "          Interaction bli {}" +
       "          Interaction blup {}" +
       "        }" +
       "      }" +
       "    }" +
       "  }" +
       "}", getTaskTree());    
  }
  
}
