//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: DefaultIterationDetectionRuleTest.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 28.04.2012 $
// Project   : TaskTreeTemporalRelationship
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012
//-------------------------------------------------------------------------------------------------
package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.guimodel.GUIElement;
import de.ugoe.cs.quest.eventcore.guimodel.TrackBar;
import de.ugoe.cs.quest.eventcore.userinteraction.ValueSelection;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 28.04.2012$
 * @author 2012, last modified by $Author: patrick$
 */
//-------------------------------------------------------------------------------------------------
public class TrackBarSelectionDetectionRuleTest extends AbstractTemporalRelationshipTC
{

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testSimpleDetection() throws Exception
  {
    GUIElement element1 = new DummyTrackBar();
    simulateInteraction(element1, new ValueSelection<Integer>(1));
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration interation1 {" +
       "    Selection selection1 {" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());    

    simulateInteraction(element1, new ValueSelection<Integer>(2));
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration interation1 {" +
       "    Selection selection1 {" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());    

    simulateInteraction(element1, new ValueSelection<Integer>(3));
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration interation1 {" +
       "    Selection selection1 {" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());    

    simulateInteraction(element1, new ValueSelection<Integer>(2));
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration interation1 {" +
       "    Selection selection1 {" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());    

    simulateInteraction(element1, new ValueSelection<Integer>(3));
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration interation1 {" +
       "    Selection selection1 {" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());

  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testComplexDetection() throws Exception
  {
    GUIElement element1 = new DummyTrackBar();
    simulateInteraction(element1, new ValueSelection<Integer>(1));
    simulateInteraction(element1, new ValueSelection<Integer>(2));
    simulateInteraction(element1, new ValueSelection<Integer>(3));
    simulateInteraction(element1, new ValueSelection<Integer>(1));
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element1, new DummyInteraction("bla", 2));
    simulateInteraction(element1, new ValueSelection<Integer>(2));
    simulateInteraction(element1, new ValueSelection<Integer>(1));
    simulateInteraction(element1, new DummyInteraction("bla", 3));
    simulateInteraction(element1, new ValueSelection<Integer>(3));
    simulateInteraction(element1, new ValueSelection<Integer>(2));
    simulateInteraction(element1, new ValueSelection<Integer>(3));
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element1, new DummyInteraction("bla", 2));
    simulateInteraction(element1, new ValueSelection<Integer>(1));
    simulateInteraction(element1, new ValueSelection<Integer>(1));
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence1 {" +
       "  Iteration interation1 {" +
       "    Selection selection1 {" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "  Interaction bla {}" +
       "  Interaction bla {}" +
       "  Iteration interation2 {" +
       "    Selection selection2 {" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "  Interaction bla {}" +
       "  Iteration interation3 {" +
       "    Selection selection3 {" +
       "      Interaction ValueSelection {}" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "  Interaction bla {}" +
       "  Interaction bla {}" +
       "  Iteration interation4 {" +
       "    Selection selection4 {" +
       "      Interaction ValueSelection {}" +
       "    }" +
       "  }" +
       "}", getTaskTree());    
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   * TODO comment
   * 
   * @version $Revision: $ $Date: 28.04.2012$
   * @author 2012, last modified by $Author: patrick$
   */
  //-----------------------------------------------------------------------------------------------
  public class DummyTrackBar extends DummyGUIElement implements TrackBar
  {

    //---------------------------------------------------------------------------------------------
    /**
     *
     */
    //---------------------------------------------------------------------------------------------
    public DummyTrackBar()
    {
      super("DummyTrackBar");
    }
  }

}
