package de.ugoe.cs.quest.plugin;

/**
 * <p>
 * This exception is thrown in case there is an error during the loading of
 * QUEST plugins. Note that the failures during the loading may result in an
 * invalid classpath and this exception should, therefore, be treated with
 * appropriate care.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class PluginLoaderException extends RuntimeException {

	/**
	 * @see RuntimeException#RuntimeException(String)
	 */
	public PluginLoaderException(String msg) {
		super(msg);
	}
	
	/**
	 * @see RuntimeException#RuntimeException(Throwable)
	 */
	public PluginLoaderException(Throwable throwable) {
		super(throwable);
	}

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

}
