//-------------------------------------------------------------------------------------------------
// Module    : $RCSfile: TaskTreeManagerTest.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 08.11.2011 21:32:36 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011
//-------------------------------------------------------------------------------------------------

package de.ugoe.cs.quest.tasktrees.temporalrelation;

import org.junit.Test;

import de.ugoe.cs.quest.eventcore.guimodel.GUIElement;
import de.ugoe.cs.quest.eventcore.userinteraction.Interaction;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;

//-------------------------------------------------------------------------------------------------
/**
 * TODO comment
 *
 * @version $Revision: $ $Date: $
 * @author  2011, last modified by $Author: $
 */
//-------------------------------------------------------------------------------------------------
public class DefaultGUIElementSequenceDetectionRuleTest extends AbstractTemporalRelationshipTC
{
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testOneInteractionOnOneElement()
  {
    simulateInteraction(new DummyGUIElement("elem1"), new DummyInteraction("bla", 1));
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence {" +
       "  Interaction bla {}" +
       "}", getTaskTree());
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testManyInteractionsOnOneElement()
  {
    GUIElement element = new DummyGUIElement("elem1");
    simulateInteraction(element, new DummyInteraction("bla", 1));
    simulateInteraction(element, new DummyInteraction("bli", 1));
    simulateInteraction(element, new DummyInteraction("blo", 1));
    simulateInteraction(element, new DummyInteraction("blu", 1));
    simulateInteraction(element, new DummyInteraction("bla", 1));
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence {" +
       "  Interaction bla {}" +
       "  Interaction bli {}" +
       "  Interaction blo {}" +
       "  Interaction blu {}" +
       "  Interaction bla {}" +
       "}", getTaskTree());
  }
  
  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testOneInteractionOnManyElements()
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    GUIElement element2 = new DummyGUIElement("elem2");
    GUIElement element3 = new DummyGUIElement("elem3");
    GUIElement element4 = new DummyGUIElement("elem4");
    GUIElement element5 = new DummyGUIElement("elem5");
    GUIElement element6 = new DummyGUIElement("elem6");
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element2, new DummyInteraction("bli", 1));
    simulateInteraction(element3, new DummyInteraction("bla", 1));
    simulateInteraction(element4, new DummyInteraction("bli", 1));
    simulateInteraction(element5, new DummyInteraction("blo", 1));
    simulateInteraction(element6, new DummyInteraction("bla", 1));

    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bli {}" +
       "  }" +
       "  Sequence sequence3 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence4 {" +
       "    Interaction bli {}" +
       "  }" +
       "  Sequence sequence5 {" +
       "    Interaction blo {}" +
       "  }" +
       "  Sequence sequence6 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", getTaskTree());
  }

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testManyInteractionsOnManyElements()
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    GUIElement element2 = new DummyGUIElement("elem2");
    GUIElement element3 = new DummyGUIElement("elem3");
    GUIElement element4 = new DummyGUIElement("elem4");
    GUIElement element5 = new DummyGUIElement("elem5");
    GUIElement element6 = new DummyGUIElement("elem6");
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element1, new DummyInteraction("bli", 1));
    simulateInteraction(element1, new DummyInteraction("bla", 1));
    simulateInteraction(element2, new DummyInteraction("bli", 1));
    simulateInteraction(element2, new DummyInteraction("blo", 1));
    simulateInteraction(element3, new DummyInteraction("bla", 1));
    simulateInteraction(element4, new DummyInteraction("bli", 1));
    simulateInteraction(element4, new DummyInteraction("bla", 1));
    simulateInteraction(element4, new DummyInteraction("bli", 1));
    simulateInteraction(element4, new DummyInteraction("blo", 1));
    simulateInteraction(element5, new DummyInteraction("bla", 1));
    simulateInteraction(element6, new DummyInteraction("bli", 1));
    simulateInteraction(element6, new DummyInteraction("bla", 1));
    simulateInteraction(element6, new DummyInteraction("bli", 1));
    simulateInteraction(element6, new DummyInteraction("blo", 1));
    
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bli {}" +
       "    Interaction blo {}" +
       "  }" +
       "  Sequence sequence3 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence4 {" +
       "    Interaction bli {}" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction blo {}" +
       "  }" +
       "  Sequence sequence5 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence6 {" +
       "    Interaction bli {}" +
       "    Interaction bla {}" +
       "    Interaction bli {}" +
       "    Interaction blo {}" +
       "  }" +
       "}", getTaskTree());
  }

  //-----------------------------------------------------------------------------------------------
  /**
   *
   */
  //-----------------------------------------------------------------------------------------------
  @Test
  public void testGUIElementHierarchyChanges() throws Exception
  {
    GUIElement element1 = new DummyGUIElement("elem1");
    GUIElement element2 = new DummyGUIElement("elem2");
    GUIElement element3 = new DummyGUIElement("elem3");
    GUIElement parent1 = new DummyGUIElement("parent1");
    GUIElement parent2 = new DummyGUIElement("parent2");
    GUIElement parent3 = new DummyGUIElement("parent3");
    
    element1.setParent(parent1);
    element2.setParent(parent2);
    element3.setParent(parent3);
    
    parent1.setParent(parent2);
    parent2.setParent(parent3);
    
    Interaction interaction1 = new DummyInteraction("bla", 1);
    simulateInteraction(element1, interaction1);
    simulateInteraction(element2, interaction1);
    simulateInteraction(element3, interaction1);
    simulateInteraction(element2, interaction1);
    simulateInteraction(element3, interaction1);
    simulateInteraction(element2, interaction1);
    simulateInteraction(element1, interaction1);
   
    new TaskTreeChecker().assertTaskTree
      ("Sequence sequence0 {" +
       "  Sequence sequence1 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Sequence sequence2 {" +
       "    Interaction bla {}" +
       "  }" +
       "  Iteration iteration0 {" +
       "    Sequence sequence3 {" +
       "      Sequence sequence4 {" +
       "        Interaction bla {}" +
       "      }" +
       "      Sequence sequence5 {" +
       "        Interaction bla {}" +
       "      }" +
       "    }" +
       "  }" +
       "  Sequence sequence6 {" +
       "    Interaction bla {}" +
       "  }" +
       "}", getTaskTree());    

  }
  
}
