package de.ugoe.cs.quest.usageprofiles.mock;

import de.ugoe.cs.quest.eventcore.IEventType;

public class StringEventType implements IEventType {
    /**  */
    private static final long serialVersionUID = 1L;
    String str;

    public StringEventType(String str) {
        if (str == null) {
            throw new AssertionError(
                                     "illegal use of mock StringEventType: str must nut be null");
        }
        this.str = str;
    }

    public String getName() {
        return "StringEventType";
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof StringEventType) {
            return str.equals(((StringEventType) other).str);
        }
        return false;
    }
}
