
package de.ugoe.cs.quest.assertions;

import java.security.InvalidParameterException;

import de.ugoe.cs.quest.eventcore.IReplayable;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * This class defines the replay for file equals assertions.
 * </p>
 * 
 * @author Jeffrey Hall, Steffen Herbold
 * @version 2.0
 */
public class FileEqualsReplay implements IReplayable {

    /**
     * <p>
     * The file that should be equal to expectedFile.
     * </p>
     */
    protected final String actualFile;

    /**
     * <p>
     * The file that is used as the reference.
     * </p>
     */
    protected final String expectedFile;

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Constructor. Creates a new FileEqualsReplay.
     * </p>
     * 
     * @param expectedFile
     *            name and path of the expected file
     * @param actualFile
     *            name and path of the actual file
     * @throws InvalidParameterException
     *             thrown if expectedFile or actualFile are null
     */
    public FileEqualsReplay(String expectedFile, String actualFile) {
        if (expectedFile == null) {
            throw new InvalidParameterException("expected file must not be null");
        }
        if (actualFile == null) {
            throw new InvalidParameterException("actual file must not be null");
        }
        this.expectedFile = expectedFile;
        this.actualFile = actualFile;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.eventcore.IReplayable#getReplay()
     */
    public String getReplay() {

        String actualFileTmp = StringTools.xmlEntityReplacement(actualFile);
        String expectedFileTmp = StringTools.xmlEntityReplacement(expectedFile);

        StringBuilder currentMsgStr = new StringBuilder(800);
        currentMsgStr.append("  <fileEquals ");
        currentMsgStr.append("actualFile=\"" + actualFileTmp + "\" ");
        currentMsgStr.append("expectedFile=\"" + expectedFileTmp + "\"/>");
        currentMsgStr.append(StringTools.ENDLINE);
        return currentMsgStr.toString();
    }

}
