package de.ugoe.cs.quest.plugin.mfc;

import de.ugoe.cs.quest.IReplayDecorator;
import de.ugoe.cs.util.StringTools;

/**
 * <p>
 * {@link IReplayDecorator} for replay generated for EventBench's MFCReplay tool.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class MFCReplayDecorator implements IReplayDecorator {

	/**
	 * <p>
	 * Id for object serialization.
	 * </p>
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * <p>
	 * The instance of the {@link MFCReplayDecorator} (implemented as
	 * singleton).
	 * </p>
	 */
	transient private static MFCReplayDecorator theInstance;

	/**
	 * <p>
	 * Constructor. Private to guarantee that only one instance of the replay
	 * generator exists.
	 * </p>
	 */
	private MFCReplayDecorator() {
	};

	/**
	 * <p>
	 * Returns the instance of the MFCReplayDecorator.
	 * </p>
	 * 
	 * @return instance of the MFCReplayDecorator.
	 */
	public static MFCReplayDecorator getInstance() {
		if (theInstance == null) {
			theInstance = new MFCReplayDecorator();
		}
		return theInstance;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.IReplayDecorator#getHeader()
	 */
	@Override
	public String getHeader() {
		return "<?xml version=\"1.0\" encoding=\"UTF-16\"?>"
				+ StringTools.ENDLINE + "<log>" + StringTools.ENDLINE;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.IReplayDecorator#getFooter()
	 */
	@Override
	public String getFooter() {
		return "</log>" + StringTools.ENDLINE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.IReplayDecorator#getSessionHeader(int)
	 */
	@Override
	public String getSessionHeader(int sessionId) {
		return " <session id=\"" + sessionId + "\">" + StringTools.ENDLINE;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.IReplayDecorator#getSessionFooter(int)
	 */
	@Override
	public String getSessionFooter(int sessionId) {
		return " </session>" + StringTools.ENDLINE;
	}

}
