// Module    : $RCSfile: KeyboardMapTest.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 11.07.2012 $
// Project   : KeyboardMaps
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012


package de.ugoe.cs.tasktree.keyboardmaps;

import static org.junit.Assert.*;

import java.util.Locale;

import org.junit.Before;
import org.junit.Test;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 11.07.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class KeyboardMapTest {

    /**
     *
     */
    @Before
    public void setUp() {
        // Logger.getLogger("").getHandlers()[0].setFormatter(new SimpleLogFormatter());
    }

    /**
     * TODO: comment
     * 
     */
    @Test
    public void testInitialization() {
        KeyboardMap map = KeyboardMapFactory.createKeyboardMap(Locale.ENGLISH);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.FRENCH);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.GERMAN);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.ITALIAN);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.JAPANESE);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.KOREAN);
        assertNotNull(map);

        try {
            map = KeyboardMapFactory.createKeyboardMap(Locale.CHINESE);
            fail("expected exception did not occur");
        }
        catch (IllegalArgumentException e) {
            // was expected and is ignored
        }

        try {
            map = KeyboardMapFactory.createKeyboardMap(Locale.SIMPLIFIED_CHINESE);
            fail("expected exception did not occur");
        }
        catch (IllegalArgumentException e) {
            // was expected and is ignored
        }

        try {
            map = KeyboardMapFactory.createKeyboardMap(Locale.TRADITIONAL_CHINESE);
            fail("expected exception did not occur");
        }
        catch (IllegalArgumentException e) {
            // was expected and is ignored
        }

        map = KeyboardMapFactory.createKeyboardMap(Locale.FRANCE);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.GERMANY);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.ITALY);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.JAPAN);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.KOREA);
        assertNotNull(map);

        try {
            map = KeyboardMapFactory.createKeyboardMap(Locale.CHINA);
            fail("expected exception did not occur");
        }
        catch (IllegalArgumentException e) {
            // was expected and is ignored
        }

        try {
            map = KeyboardMapFactory.createKeyboardMap(Locale.PRC);
            fail("expected exception did not occur");
        }
        catch (IllegalArgumentException e) {
            // was expected and is ignored
        }

        try {
            map = KeyboardMapFactory.createKeyboardMap(Locale.TAIWAN);
            fail("expected exception did not occur");
        }
        catch (IllegalArgumentException e) {
            // was expected and is ignored
        }

        map = KeyboardMapFactory.createKeyboardMap(Locale.UK);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.US);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.CANADA);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.CANADA_FRENCH);
        assertNotNull(map);

        map = KeyboardMapFactory.createKeyboardMap(Locale.GERMAN);
        assertNotNull(map);

    }

    /**
     * TODO: comment
     * 
     */
    @Test
    public void testGermanKeyboardMap() {
        KeyboardMap map = KeyboardMapFactory.createKeyboardMap(Locale.GERMAN);
        assertNotNull(map);

        assertCombinations(map, VirtualKey.DIGIT_1, '1', '!', '¹', '¡', true);
        assertCombinations(map, VirtualKey.EXCLAMATION_MARK, '1', '!', '¹', '¡', true);
        assertCombinations(map, VirtualKey.INVERTED_EXCLAMATION_MARK, '1', '!', '¹', '¡', true);

        assertCombinations(map, VirtualKey.DIGIT_2, '2', '"', '²', '⅛', true);
        assertCombinations(map, VirtualKey.QUOTEDBL, '2', '"', '²', '⅛', true);

        assertCombinations(map, VirtualKey.DIGIT_3, '3', '§', '³', '£', true);

        assertCombinations(map, VirtualKey.DIGIT_4, '4', '$', '¼', '¤', true);
        assertCombinations(map, VirtualKey.DOLLAR, '4', '$', '¼', '¤', true);

        assertCombinations(map, VirtualKey.DIGIT_5, '5', '%', '½', '⅜', true);

        assertCombinations(map, VirtualKey.DIGIT_6, '6', '&', '¾', '⅝', true);
        assertCombinations(map, VirtualKey.AMPERSAND, '6', '&', '¾', '⅝', true);

        assertCombinations(map, VirtualKey.DIGIT_7, '7', '/', '{', '⅞', true);
        assertCombinations(map, VirtualKey.SLASH, '7', '/', '{', '⅞', true);
        assertCombinations(map, VirtualKey.BRACELEFT, '7', '/', '{', '⅞', true);

        assertCombinations(map, VirtualKey.DIGIT_8, '8', '(', '[', '™', true);
        assertCombinations(map, VirtualKey.LEFT_PARENTHESIS, '8', '(', '[', '™', true);
        assertCombinations(map, VirtualKey.OPEN_BRACKET, '8', '(', '[', '™', true);

        assertCombinations(map, VirtualKey.DIGIT_9, '9', ')', ']', '±', true);
        assertCombinations(map, VirtualKey.RIGHT_PARENTHESIS, '9', ')', ']', '±', true);
        assertCombinations(map, VirtualKey.CLOSE_BRACKET, '9', ')', ']', '±', true);

        assertCombinations(map, VirtualKey.DIGIT_0, '0', '=', '}', 0, true);
        assertCombinations(map, VirtualKey.EQUALS, '0', '=', '}', 0, true);
        assertCombinations(map, VirtualKey.BRACERIGHT, '0', '=', '}', 0, true);

        assertCombinations(map, VirtualKey.BACK_SLASH, 'ß', '?', '\\', '¿', true);

        assertCombinations(map, VirtualKey.LETTER_Q, 'q', 'Q', '@', 'Ω', true);
        assertCombinations(map, VirtualKey.AT, 'q', 'Q', '@', 'Ω', true);

        assertCombinations(map, VirtualKey.LETTER_W, 'w', 'W', 0, 0, true);

        assertCombinations(map, VirtualKey.LETTER_E, 'e', 'E', '€', 0, true);
        assertCombinations(map, VirtualKey.EURO_SIGN, 'e', 'E', '€', 0, true);

        assertCombinations(map, VirtualKey.LETTER_R, 'r', 'R', 0, '®', true);

        assertCombinations(map, VirtualKey.LETTER_T, 't', 'T', 'ŧ', 'Ŧ', true);

        assertCombinations(map, VirtualKey.LETTER_Z, 'z', 'Z', '←', '¥', true);

        assertCombinations(map, VirtualKey.LETTER_U, 'u', 'U', '↓', '↑', true);

        assertCombinations(map, VirtualKey.LETTER_I, 'i', 'I', '→', 'ı', true);

        assertCombinations(map, VirtualKey.LETTER_O, 'o', 'O', 'ø', 'Ø', true);

        assertCombinations(map, VirtualKey.LETTER_P, 'p', 'P', 'þ', 'Þ', true);

        assertCombinations(map, VirtualKey.LETTER_A, 'a', 'A', 'æ', 'Æ', true);

        assertCombinations(map, VirtualKey.LETTER_S, 's', 'S', 0, 0, true);

        assertCombinations(map, VirtualKey.LETTER_D, 'd', 'D', 'ð', 'Ð', true);

        assertCombinations(map, VirtualKey.LETTER_F, 'f', 'F', 'đ', 'ª', true);

        assertCombinations(map, VirtualKey.LETTER_G, 'g', 'G', 'ŋ', 'Ŋ', true);

        assertCombinations(map, VirtualKey.LETTER_H, 'h', 'H', 'ħ', 'Ħ', true);

        assertCombinations(map, VirtualKey.LETTER_J, 'j', 'J', 0, 0, true);

        assertCombinations(map, VirtualKey.LETTER_K, 'k', 'K', 'ĸ', 0, true);

        assertCombinations(map, VirtualKey.LETTER_L, 'l', 'L', 0, 0, true);

        assertCombinations(map, VirtualKey.LETTER_Y, 'y', 'Y', '»', 0, true);

        assertCombinations(map, VirtualKey.LETTER_X, 'x', 'X', '«', 0, true);

        assertCombinations(map, VirtualKey.LETTER_C, 'c', 'C', '¢', '©', true);

        assertCombinations(map, VirtualKey.LETTER_V, 'v', 'V', '„', 0, true);

        assertCombinations(map, VirtualKey.LETTER_B, 'b', 'B', '“', 0, true);

        assertCombinations(map, VirtualKey.LETTER_N, 'n', 'N', 0, 0, true);

        assertCombinations(map, VirtualKey.LETTER_M, 'm', 'M', 'µ', 'º', true);

        assertCombinations(map, VirtualKey.NUMPAD_0, '0', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_1, '1', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_2, '2', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_3, '3', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_4, '4', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_5, '5', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_6, '6', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_7, '7', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_8, '8', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.NUMPAD_9, '9', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.SEPARATOR, ',', 0, 0, 0, false);
        assertCombinations(map, VirtualKey.DECIMAL, ',', 0, 0, 0, false);

        assertCombinations(map, VirtualKey.CIRCUMFLEX, '^', '°', '¬', 0, true);

        assertCombinations(map, VirtualKey.TAB, '\t', 0, '\t', 0, true);

        assertCombinations(map, VirtualKey.SPACE, ' ', ' ', ' ', ' ', true);

        assertCombinations(map, VirtualKey.COMMA, ',', ';', '·', '×', true);
        assertCombinations(map, VirtualKey.SEMICOLON, ',', ';', '·', '×', true);
        assertCombinations(map, VirtualKey.MULTIPLY, ',', ';', '·', '×', true);

        assertCombinations(map, VirtualKey.MINUS, '-', '_', 0, 0, true);
        assertCombinations(map, VirtualKey.UNDERSCORE, '-', '_', 0, 0, true);

        assertCombinations(map, VirtualKey.PERIOD, '.', ':', '…', '÷', true);
        assertCombinations(map, VirtualKey.COLON, '.', ':', '…', '÷', true);
        assertCombinations(map, VirtualKey.DIVIDE, '.', ':', '…', '÷', true);

        assertCombinations(map, VirtualKey.PLUS, '+', '*', '~', 0, true);
        assertCombinations(map, VirtualKey.ASTERISK, '+', '*', '~', 0, true);
        assertCombinations(map, VirtualKey.DEAD_TILDE, '+', '*', '~', 0, true);

        assertCombinations(map, VirtualKey.LESS, '<', '>', '|', '¦', true);
        assertCombinations(map, VirtualKey.GREATER, '<', '>', '|', '¦', true);

        assertCombinations(map, VirtualKey.NUMBER_SIGN, '#', '\'', 0, 0, true);

        /*
         * DEAD_GRAVE(KeyEvent.VK_DEAD_GRAVE), DEAD_ACUTE(KeyEvent.VK_DEAD_ACUTE),
         * DEAD_CIRCUMFLEX(KeyEvent.VK_DEAD_CIRCUMFLEX), DEAD_TILDE(KeyEvent.VK_DEAD_TILDE),
         * DEAD_MACRON(KeyEvent.VK_DEAD_MACRON), DEAD_BREVE(KeyEvent.VK_DEAD_BREVE),
         * DEAD_ABOVEDOT(KeyEvent.VK_DEAD_ABOVEDOT), DEAD_DIAERESIS(KeyEvent.VK_DEAD_DIAERESIS),
         * DEAD_ABOVERING(KeyEvent.VK_DEAD_ABOVERING),
         * DEAD_DOUBLEACUTE(KeyEvent.VK_DEAD_DOUBLEACUTE), DEAD_CARON(KeyEvent.VK_DEAD_CARON),
         * DEAD_CEDILLA(KeyEvent.VK_DEAD_CEDILLA), DEAD_OGONEK(KeyEvent.VK_DEAD_OGONEK),
         * DEAD_IOTA(KeyEvent.VK_DEAD_IOTA), DEAD_VOICED_SOUND(KeyEvent.VK_DEAD_VOICED_SOUND),
         * DEAD_SEMIVOICED_SOUND(KeyEvent.VK_DEAD_SEMIVOICED_SOUND),
         */
    }

    /**
   *
   */
    private void assertCombinations(KeyboardMap map,
                                    VirtualKey  key,
                                    int         normal,
                                    int         withShift,
                                    int         withAltGr,
                                    int         withShiftAndAltGr,
                                    boolean     numLockIndependent)
    {
        if (numLockIndependent) {
            if (normal != 0) {
                assertCombination("normal", normal, map, key, false, false, false);
            }

            if (withShift != 0) {
                assertCombination("shift", withShift, map, key, false, true, false);
            }

            if (withAltGr != 0) {
                assertCombination("altgr", withAltGr, map, key, false, false, true);
            }

            if (withShiftAndAltGr != 0) {
                assertCombination("shift and altgr", withShiftAndAltGr, map, key, false, true, true);
            }
        }
        else {
            assertInvalidCombination("normal", normal, map, key, false, false, false);
            assertInvalidCombination("shift", withShift, map, key, false, true, false);
            assertInvalidCombination("altgr", withAltGr, map, key, false, false, true);
            assertInvalidCombination
              ("shift and altgr", withShiftAndAltGr, map, key, false, true, true);
        }

        if (normal != 0) {
            assertCombination("numlock", normal, map, key, true, false, false);
        }

        if (withShift != 0) {
            assertCombination("numlock and shift", withShift, map, key, true, true, false);
        }

        if (withAltGr != 0) {
            assertCombination("numlock and altgr", withAltGr, map, key, true, false, true);
        }

        if (withShiftAndAltGr != 0) {
            assertCombination
              ("numlock, shift and altgr", withShiftAndAltGr, map, key, true, true, true);
        }
    }

    /**
     * TODO: comment
     * 
     * @param string
     * @param normal
     * @param characterFor
     */
    private void assertCombination(String      type,
                                   int         expectedChar,
                                   KeyboardMap map,
                                   VirtualKey  key,
                                   boolean     numlock,
                                   boolean     shift,
                                   boolean     altgr)
    {
        String message = "checked for " + type + ": expected '" + ((char) expectedChar) + "'";

        char retrievedChar;
        try {
            retrievedChar = map.getCharacterFor(key, numlock, shift, altgr, false);
        }
        catch (IllegalArgumentException e) {
            fail("no character found. " + message);
            return;
        }

        message += " but got '" + retrievedChar + "'";

        assertEquals(message, expectedChar, retrievedChar);
    }

    /**
     * TODO: comment
     * 
     * @param string
     * @param normal
     * @param characterFor
     */
    private void assertInvalidCombination(String      type,
                                          int         expectedChar,
                                          KeyboardMap map,
                                          VirtualKey  key,
                                          boolean     numlock,
                                          boolean     shift,
                                          boolean     altgr)
    {
        char retrievedChar;
        try {
            retrievedChar = map.getCharacterFor(key, numlock, shift, altgr, false);
            assertEquals(Character.UNASSIGNED, retrievedChar);
        }
        catch (IllegalArgumentException e) {
            // this is ok and checked for
        }

    }

}
