/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.LightRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedCollection;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.RenderBin;
import javax.media.j3d.VirtualUniverse;

class LightBin
implements ObjectUpdate {
    int maxLights = -1;
    LightRetained[] lights = null;
    int[] lightsRef = null;
    int numEmptySlots = -1;
    RenderBin renderBin = null;
    LightBin next = null;
    LightBin prev = null;
    EnvironmentSet environmentSetList = null;
    ArrayList insertEnvSet = new ArrayList();
    int canvasDirty = 0;
    int lightDirtyMaskCache = 0;
    int lightDirtyMask = 0;
    ArrayList pointLts = new ArrayList();
    int[] pointLtsSlotIndex;
    OrderedCollection orderedCollection = null;
    boolean onUpdateList = false;
    BackgroundRetained geometryBackground = null;

    LightBin(int n, RenderBin renderBin, boolean bl) {
        this.maxLights = n;
        this.numEmptySlots = n;
        this.lights = new LightRetained[n];
        this.lightsRef = new int[n];
        this.renderBin = renderBin;
    }

    void reset(boolean bl) {
        this.prev = null;
        this.next = null;
        this.orderedCollection = null;
        this.environmentSetList = null;
        this.onUpdateList = false;
        this.geometryBackground = null;
    }

    void setOrderedInfo(OrderedCollection orderedCollection) {
        this.orderedCollection = orderedCollection;
    }

    boolean willEnvironmentSetFit(EnvironmentSet environmentSet) {
        int n;
        int n2 = n = environmentSet.lights.size();
        int n3 = 0;
        while (n3 < n) {
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(n3);
            if (!(lightRetained instanceof AmbientLightRetained)) {
                int n4 = 0;
                while (n4 < this.maxLights) {
                    if (this.lights[n4] == lightRetained) {
                        --n2;
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return n2 <= this.numEmptySlots;
    }

    void addEnvironmentSet(EnvironmentSet environmentSet, RenderBin renderBin) {
        int n = environmentSet.lights.size();
        int n2 = 0;
        while (n2 < n) {
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(n2);
            if (!(lightRetained instanceof AmbientLightRetained)) {
                int n3 = 0;
                while (n3 < this.maxLights) {
                    if (this.lights[n3] == lightRetained) {
                        if (lightRetained.lightOn) {
                            environmentSet.enableMask |= (long)(1 << n3);
                        }
                        int n4 = n3;
                        this.lightsRef[n4] = this.lightsRef[n4] + 1;
                        environmentSet.ltPos[n2] = n3;
                        break;
                    }
                    ++n3;
                }
                if (n3 == this.maxLights) {
                    n3 = 0;
                    while (n3 < this.maxLights) {
                        if (this.lights[n3] == null) {
                            this.lights[n3] = lightRetained;
                            this.lightsRef[n3] = 1;
                            if (lightRetained instanceof PointLightRetained) {
                                this.pointLts.add(lightRetained);
                                int n5 = 0;
                                if (this.pointLtsSlotIndex != null) {
                                    n5 = this.pointLtsSlotIndex.length;
                                }
                                if (n5 < this.pointLts.size()) {
                                    int[] nArray = new int[n5 + 8];
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        nArray[n6] = this.pointLtsSlotIndex[n6];
                                        ++n6;
                                    }
                                    this.pointLtsSlotIndex = nArray;
                                }
                                this.pointLtsSlotIndex[this.pointLts.size() - 1] = n3;
                            }
                            if (lightRetained.lightOn) {
                                environmentSet.enableMask |= (long)(1 << n3);
                            }
                            environmentSet.ltPos[n2] = n3;
                            --this.numEmptySlots;
                            break;
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        environmentSet.lightBin = this;
        environmentSet.enableMaskCache = environmentSet.enableMask;
        this.insertEnvSet.add(environmentSet);
        if (!this.onUpdateList) {
            renderBin.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    public void updateObject() {
        int n;
        if (this.insertEnvSet.size() > 0) {
            EnvironmentSet environmentSet = (EnvironmentSet)this.insertEnvSet.get(0);
            if (this.environmentSetList == null) {
                this.environmentSetList = environmentSet;
            } else {
                environmentSet.next = this.environmentSetList;
                this.environmentSetList.prev = environmentSet;
                this.environmentSetList = environmentSet;
            }
            n = 1;
            while (n < this.insertEnvSet.size()) {
                environmentSet = (EnvironmentSet)this.insertEnvSet.get(n);
                environmentSet.next = this.environmentSetList;
                this.environmentSetList.prev = environmentSet;
                this.environmentSetList = environmentSet;
                ++n;
            }
        }
        this.insertEnvSet.clear();
        if (this.canvasDirty != 0) {
            Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
            n = 0;
            while (n < canvas3DArray.length) {
                canvas3DArray[n].canvasDirty |= this.canvasDirty;
                ++n;
            }
            this.lightDirtyMask = this.lightDirtyMaskCache;
            this.canvasDirty = 0;
            this.lightDirtyMaskCache = 0;
        }
        this.onUpdateList = false;
    }

    void removeEnvironmentSet(EnvironmentSet environmentSet) {
        environmentSet.lightBin = null;
        if (this.insertEnvSet.contains(environmentSet)) {
            this.insertEnvSet.remove(this.insertEnvSet.indexOf(environmentSet));
        } else {
            int n = environmentSet.lights.size();
            int n2 = 0;
            while (n2 < n) {
                LightRetained lightRetained = (LightRetained)environmentSet.lights.get(n2);
                int n3 = 0;
                while (n3 < this.maxLights) {
                    if (this.lights[n3] == lightRetained) {
                        int n4 = n3;
                        this.lightsRef[n4] = this.lightsRef[n4] - 1;
                        if (this.lightsRef[n3] != 0) break;
                        if (lightRetained instanceof PointLightRetained) {
                            this.pointLts.remove(this.pointLts.indexOf(lightRetained));
                        }
                        this.lights[n3] = null;
                        this.lightDirtyMaskCache &= ~(1 << n3);
                        this.lightDirtyMask &= ~(1 << n3);
                        ++this.numEmptySlots;
                        break;
                    }
                    ++n3;
                }
                ++n2;
            }
            if (environmentSet.prev == null) {
                this.environmentSetList = environmentSet.next;
                if (environmentSet.next != null) {
                    environmentSet.next.prev = null;
                }
            } else {
                environmentSet.prev.next = environmentSet.next;
                if (environmentSet.next != null) {
                    environmentSet.next.prev = environmentSet.prev;
                }
            }
            Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
            n2 = 0;
            while (n2 < canvas3DArray.length) {
                canvas3DArray[n2].environmentSet = null;
                ++n2;
            }
        }
        environmentSet.prev = null;
        environmentSet.next = null;
        this.renderBin.envSetFreelist.add(environmentSet);
        if (this.environmentSetList == null && this.insertEnvSet.size() == 0) {
            this.renderBin.removeLightBin(this);
            this.geometryBackground = null;
        }
    }

    void render(Canvas3D canvas3D) {
        canvas3D.setStateToUpdate(0, this);
        EnvironmentSet environmentSet = this.environmentSetList;
        while (environmentSet != null) {
            environmentSet.render(canvas3D);
            environmentSet = environmentSet.next;
        }
    }

    void updateAttributes(Canvas3D canvas3D) {
        int n = VirtualUniverse.mc.frameCount;
        if (canvas3D.lightBin != this) {
            double d;
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            int n2 = 0;
            while (n2 < this.maxLights) {
                if (this.lights[n2] != null && (canvas3D.lights[n2] != this.lights[n2] || canvas3D.frameCount[n2] != n)) {
                    canvas3D.lights[n2] = this.lights[n2];
                    canvas3D.frameCount[n2] = n;
                    this.lights[n2].update(canvas3D.ctx, n2, d);
                }
                ++n2;
            }
            canvas3D.lightBin = this;
            canvas3D.canvasDirty &= 0xFFFFFFBF;
            canvas3D.enableMask = -1L;
        } else if ((canvas3D.canvasDirty & 0x40) != 0) {
            double d;
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            int n3 = 0;
            int n4 = this.lightDirtyMask;
            while (n4 != 0) {
                if ((n4 & 1) != 0) {
                    this.lights[n3].update(canvas3D.ctx, n3, d);
                    canvas3D.lights[n3] = this.lights[n3];
                    canvas3D.frameCount[n3] = n;
                }
                n4 >>= 1;
                ++n3;
            }
            canvas3D.canvasDirty &= 0xFFFFFFBF;
        } else if (this.pointLts.size() > 0 && (canvas3D.canvasDirty & 0x8000) != 0) {
            double d;
            if (this.geometryBackground == null) {
                d = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            int n5 = 0;
            while (n5 < this.pointLts.size()) {
                LightRetained lightRetained = (LightRetained)this.pointLts.get(n5);
                lightRetained.update(canvas3D.ctx, this.pointLtsSlotIndex[n5], d);
                canvas3D.lights[this.pointLtsSlotIndex[n5]] = lightRetained;
                canvas3D.frameCount[this.pointLtsSlotIndex[n5]] = n;
                ++n5;
            }
        }
    }
}

