#include "stdafx.h"
#include "helpers.h"

bool MessageEquals(const MSG & msg1, const MSG & msg2) {
	bool retVal = false;
	if( (msg1.time==-1 && msg1.pt.x==-1 && msg1.pt.y==-1) || (msg2.time==-1 && msg2.pt.x==-1 && msg2.pt.y==-1) ) {
		retVal = msg1.hwnd==msg2.hwnd && msg1.message==msg2.message && msg1.lParam==msg2.lParam &&
			msg1.wParam==msg2.wParam;
	} else {
		retVal = msg1.hwnd==msg2.hwnd && msg1.message==msg2.message && msg1.lParam==msg2.lParam &&
			msg1.wParam==msg2.wParam && msg1.time==msg2.time && msg1.pt.x==msg2.pt.x && msg1.pt.y==msg2.pt.y;
	}
	return retVal;
}

int replaceWithXmlEntitiesWString(const wchar_t * source, wchar_t ** target, size_t sourceLength) {
	size_t j=0;
	size_t extraLength = 0;
	size_t bufsize = 300;
	wchar_t * tmpTarget = new wchar_t[sourceLength+bufsize];
	size_t i;
	for( i=0; i<sourceLength && j<sourceLength+bufsize-5; i++ ) {
		switch (source[i]) {
			case L'&':
				tmpTarget[j] = L'&';
				tmpTarget[j+1]=L'a';
				tmpTarget[j+2]=L'm';
				tmpTarget[j+3]=L'p';
				tmpTarget[j+4]=L';';
				j += 5;
				extraLength += 4;
				break;
			case L'<':
				tmpTarget[j] = L'&';
				tmpTarget[j+1]=L'l';
				tmpTarget[j+2]=L't';
				tmpTarget[j+3]=L';';
				j += 4;
				extraLength += 3;
				break;
			case L'>':
				tmpTarget[j] = L'&';
				tmpTarget[j+1]=L'g';
				tmpTarget[j+2]=L't';
				tmpTarget[j+3]=L';';
				j += 4;
				extraLength += 3;
				break;
			case L'\"':
				tmpTarget[j] = L'&';
				tmpTarget[j+1]=L'q';
				tmpTarget[j+2]=L'u';
				tmpTarget[j+3]=L'o';
				tmpTarget[j+4]=L't';
				tmpTarget[j+5]=L';';
				j += 6;
				extraLength += 5;
				break;
			case L'\'':
				tmpTarget[j] = L'&';
				tmpTarget[j+1]=L'a';
				tmpTarget[j+2]=L'p';
				tmpTarget[j+3]=L'o';
				tmpTarget[j+4]=L's';
				tmpTarget[j+5]=L';';
				j += 6;
				extraLength += 5;
				break;
			case L'%':
				tmpTarget[j] = L'\\';
				tmpTarget[j+1] = L'%';
				j += 2;
				extraLength += 1;
				break;
			default:
				tmpTarget[j] = source[i];
				j++;
		}
	}
	*target = new wchar_t[j+1];
	memcpy(*target,tmpTarget,j*sizeof(wchar_t));
	(*target)[j] = '\0';
	return j;
}