// Module    : $RCSfile: JFCHGUIElementSpec.java,v $
// Version   : $Revision: 0.0 $  $Author: pharms $  $Date: 17.08.2012 $
// Project   : quest-plugin-jfc
// Creation  : 2012 by pharms
// Copyright : Patrick Harms, 2012
package de.ugoe.cs.quest.plugin.jfc.guimodel;

import de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: 17.08.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class JFCGUIElementSpec implements IGUIElementSpec {

    /** */
    private String name;
    
    /** */
    private String type;
    
    /** */
    private String icon;
    
    /** */
    private int index;
    
    /** */
    private int elementHash;
    
    /* (non-Javadoc)
     * @see de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec#getSecificationSimilarity(IGUIElementSpec)
     */
    @Override
    public int getSimilarity(IGUIElementSpec other) {
        if (this == other)
        {
            return 100;
        }
        
        if (!(other instanceof JFCGUIElementSpec))
        {
            return 0;
        }
        
        JFCGUIElementSpec otherSpec = (JFCGUIElementSpec) other;
        int result = 0;

        if ((type == otherSpec.type) || ((type != null) && (type.equals(otherSpec.type)))) {
            result += 50;
        }

        if ((icon == otherSpec.icon) || ((icon != null) && (icon.equals(otherSpec.icon)))) {
            result += 10;
        }

        if (index == otherSpec.index) {
            result += 10;
        }

        if ((name == otherSpec.name) || ((name != null) && (name.equals(otherSpec.name)))) {
            result += 15;
        }

        if (elementHash == otherSpec.elementHash) {
            result += 15;
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec#equals(IGUIElementSpec)
     */
    @Override
    public boolean equals(IGUIElementSpec other) {
        if (this == other)
        {
            return true;
        }
        
        if (!(other instanceof JFCGUIElementSpec))
        {
            return false;
        }
        
        JFCGUIElementSpec otherSpec = (JFCGUIElementSpec) other;
        
        return
            ((name == otherSpec.name) || ((name != null) && (name.equals(otherSpec.name)))) &&
            ((type == otherSpec.type) || ((type != null) && (type.equals(otherSpec.type)))) &&
            ((icon == otherSpec.icon) || ((icon != null) && (icon.equals(otherSpec.icon)))) &&
            (index == otherSpec.index) && (elementHash == otherSpec.elementHash);
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @return the title
     */
    public String getType() {
        return type;
    }

    /**
     * @return the icon
     */
    public String getIcon() {
        return icon;
    }

    /**
     * @return the index
     */
    public int getIndex() {
        return index;
    }

    /**
     * @return the elementHash
     */
    public int getElementHash() {
        return elementHash;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @param title the title to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @param icon the icon to set
     */
    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     * @param index the index to set
     */
    public void setIndex(int index) {
        this.index = index;
    }

    /**
     * @param elementHash the elementHash to set
     */
    public void setElementHash(int elementHash) {
        this.elementHash = elementHash;
    }

}
