// Module    : $RCSfile: TaskTreeNodeFactoryImpl.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 21.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012


package de.ugoe.cs.quest.tasktrees.treeimpl;

import de.ugoe.cs.quest.eventcore.IEventTarget;
import de.ugoe.cs.quest.eventcore.IEventType;
import de.ugoe.cs.quest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.quest.tasktrees.treeifc.IIteration;
import de.ugoe.cs.quest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.quest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeifc.ITextInputEventTask;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 21.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class TaskTreeNodeFactory implements ITaskTreeNodeFactory {

    /*
     * (non-Javadoc)
     * 
     * @see TaskTreeNodeFactory#createNewEventTask(IEventType, IEventTarget)
     */
    @Override
    public IEventTask createNewEventTask(IEventType eventType, IEventTarget eventTarget) {
        return new EventTask(eventType, eventTarget);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewSequence()
     */
    @Override
    public ISequence createNewSequence() {
        return new Sequence();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewTextInputEventTask(eventTarget)
     */
    @Override
    public ITextInputEventTask createNewTextInputEventTask(IEventTarget eventTarget) {
        return new TextInputEventTask(eventTarget);
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewIteration()
     */
    @Override
    public IIteration createNewIteration() {
        return new Iteration();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createNewSelection()
     */
    @Override
    public ISelection createNewSelection() {
        return new Selection();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.tasktree.treeifc.TaskTreeNodeFactory#createTaskTree(de.ugoe.cs.tasktree.treeifc
     * .TaskTreeNode)
     */
    @Override
    public ITaskTree createTaskTree(ITaskTreeNode root) {
        return new TaskTree(root);
    }

}
