package de.ugoe.cs.quest.plugin.mfc;

import de.ugoe.cs.quest.plugin.mfc.eventcore.WindowTree;

/**
 * <p>
 * Message handler for {@code WM_CREATE} messages. The handler maintains the
 * {@link WindowTree}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class HandlerCreate extends MessageHandler {

	/**
	 * <p>
	 * Constructor. Creates a new HandlerCreate.
	 * </p>
	 */
	public HandlerCreate() {
		super();
	}

	/**
	 * <p>
	 * Name of the created window.
	 * </p>
	 */
	private String windowName;

	/**
	 * <p>
	 * HWND of the created window.
	 * </p>
	 */
	private int hwnd;

	/**
	 * <p>
	 * HWND of the created window's parent.
	 * </p>
	 */
	private int parentHwnd;

	/**
	 * <p>
	 * Resource Id of the created window.
	 * </p>
	 */
	private int resourceId;

	/**
	 * <p>
	 * Window class of the created window.
	 * </p>
	 */
	private String className;

	/**
	 * <p>
	 * Modality of the created window.
	 * </p>
	 */
	private boolean isModal;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onEndElement()
	 */
	@Override
	public void onEndElement() {
		if (hwnd != 0) {
			WindowTree.getInstance().add(parentHwnd, hwnd, windowName,
					resourceId, className, isModal);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.quest.plugin.mfc.MessageHandler#onParameter(java.lang.String
	 * , java.lang.String)
	 */
	@Override
	public void onParameter(String name, String value) {
		if (name.equals("window.hwnd")) {
			hwnd = Integer.parseInt(value);
		} else if (name.equals("window.name")) {
			windowName = value;
		} else if (name.equals("window.parent.hwnd")) {
			parentHwnd = Integer.parseInt(value);
		} else if (name.equals("window.resourceId")) {
			resourceId = Integer.parseInt(value);
		} else if (name.equals("window.class")) {
			if (value.startsWith("Afx:")) {
				className = "Afx:";
			} else {
				className = value;
			}
		} else if (name.equals("window.ismodal")) {
			if (value.equals("true") || value.equals("1")) {
				isModal = true;
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onStartElement()
	 */
	@Override
	public void onStartElement() {
		windowName = "";
		hwnd = 0;
		parentHwnd = 0;
		resourceId = 0;
		className = "";
		isModal = false;
	}

}
