/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorClassLoader
extends ClassLoader {
    ValidatorClassLoader() {
        super(ClassLoader.getSystemClassLoader().getParent());
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("javax.annotation")) {
            return Class.forName(name);
        }
        try {
            byte[] b = this.loadClassData(name);
            return this.defineClass(name, b, 0, b.length);
        }
        catch (CheckedAnalysisException e) {
            return super.findClass(name);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    private byte[] loadClassData(String name) throws CheckedAnalysisException {
        ClassDescriptor d = DescriptorFactory.createClassDescriptorFromDottedClassName(name);
        ClassData data = Global.getAnalysisCache().getClassAnalysis(ClassData.class, d);
        return data.getData();
    }
}

