/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.matrix;

import edu.uci.ics.jung.algorithms.matrix.MatrixElementOperations;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealMatrixElementOperations<E>
implements MatrixElementOperations<E> {
    private Map<E, Number> edgeData = new HashMap<E, Number>();

    public RealMatrixElementOperations(Map<E, Number> edgeData) {
        this.edgeData = edgeData;
    }

    @Override
    public void mergePaths(E e, Object pathData) {
        Number pd = (Number)pathData;
        Number ed = this.edgeData.get(e);
        if (ed == null) {
            this.edgeData.put(e, pd);
        } else {
            this.edgeData.put(e, ed.doubleValue() + pd.doubleValue());
        }
    }

    @Override
    public Number computePathData(E e1, E e2) {
        double d1 = this.edgeData.get(e1).doubleValue();
        double d2 = this.edgeData.get(e2).doubleValue();
        return d1 * d2;
    }

    @Override
    public Map<E, Number> getEdgeData() {
        return this.edgeData;
    }
}

