// Module    : $RCSfile: JFCHGUIElementSpec.java,v $
// Version   : $Revision: 0.0 $  $Author: pharms $  $Date: 17.08.2012 $
// Project   : quest-plugin-jfc
// Creation  : 2012 by pharms
// Copyright : Patrick Harms, 2012
package de.ugoe.cs.quest.plugin.jfc.guimodel;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.collections15.CollectionUtils;

import de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @version $Revision: $ $Date: 17.08.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class JFCGUIElementSpec implements IGUIElementSpec {

    /** */
    private List<String> name = new LinkedList<String>();
    
    /** */
    private String type = null;
    
    /** */
    private String icon = null;
    
    /** */
    private int index = -1;
    
    /** */
    private List<String> elementHash = new LinkedList<String>();
    
    /* (non-Javadoc)
     * @see de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec#getSecificationSimilarity(IGUIElementSpec)
     */
    @Override
    public boolean getSimilarity(IGUIElementSpec other) {
        if (this == other)
        {
            return true;
        }
        
        if (!(other instanceof JFCGUIElementSpec))
        {
            return false;
        }
        
        JFCGUIElementSpec otherSpec = (JFCGUIElementSpec) other;
        
        boolean retVal = false;
        
        boolean titleEqual = CollectionUtils.containsAny(name, otherSpec.name);
        boolean hashEqual = CollectionUtils.containsAny(elementHash, otherSpec.elementHash);
        
        if (type.equals("Class") ) {
            retVal = type.equals(otherSpec.type) && (titleEqual || hashEqual);
        }
        else {
            retVal = type.equals(otherSpec.type) && index==otherSpec.index &&
                (titleEqual || hashEqual);
        }
        
        return retVal;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.quest.eventcore.guimodel.IGUIElementSpec#equals(IGUIElementSpec)
     */
    @Override
    public boolean equals(IGUIElementSpec other) {
        if (this == other)
        {
            return true;
        }
        
        if (!(other instanceof JFCGUIElementSpec))
        {
            return false;
        }
        
        JFCGUIElementSpec otherSpec = (JFCGUIElementSpec) other;
        
        return
            ((name == otherSpec.name) || ((name != null) && (name.equals(otherSpec.name)))) &&
            ((type == otherSpec.type) || ((type != null) && (type.equals(otherSpec.type)))) &&
            ((icon == otherSpec.icon) || ((icon != null) && (icon.equals(otherSpec.icon)))) &&
            (index == otherSpec.index) && (elementHash == otherSpec.elementHash);
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return (name + type + icon + index + elementHash).hashCode();
    }

    /**
     * @return the name
     */
    public String getName() {
        // TODO for now always returns first matched name
        if( name.isEmpty() ) {
            return null;
        }
        return name.get(0);
    }

    /**
     * @return the title
     */
    public String getType() {
        return type;
    }

    /**
     * @return the icon
     */
    public String getIcon() {
        return icon;
    }

    /**
     * @return the index
     */
    public int getIndex() {
        return index;
    }

    /**
     * @return the elementHash
     */
    public String getElementHash() {
        // TODO for now always returns the first hash value
        if( elementHash.isEmpty() ) {
            return null;
        }
        return elementHash.get(0);
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        if( !this.name.contains(name) && name!=null ) {
            this.name.add(name);
        }
    }

    /**
     * @param title the title to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @param icon the icon to set
     */
    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     * @param index the index to set
     */
    public void setIndex(int index) {
        this.index = index;
    }

    /**
     * @param elementHash the elementHash to set
     */
    public void setElementHash(String elementHash) {
        if( !this.elementHash.contains(elementHash) ) {
            this.elementHash.add(elementHash);
        }
    }
    
    public String toString() {
        return "" + name.toString() + "," + elementHash.toString() + "," + type + "," + "icon";
    }

}
