package de.ugoe.cs.quest.ui.commands;

import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.quest.CommandHelpers;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.testgeneration.HybridGenerator;
import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.quest.usageprofiles.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Command to generate sequences of a given length.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDgenerateHybrid implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		String sequencesName;
		int length;
		int maxLengthAll;
		int numSequences;
		boolean validEnd = true;
		try {
			modelname = (String) parameters.get(0);
			sequencesName = (String) parameters.get(1);
			length = Integer.parseInt((String) parameters.get(2));
			maxLengthAll = Integer.parseInt((String) parameters.get(3));
			numSequences = Integer.parseInt((String) parameters.get(4));
			if (parameters.size() >= 6) {
				validEnd = Boolean.parseBoolean((String) parameters.get(5));
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}

		if (length <= maxLengthAll) {
			// indirectly call command generateFixedLengthSequences
			List<Object> parameters2 = new LinkedList<Object>();
			parameters2.add(modelname);
			parameters2.add(sequencesName);
			parameters2.add(Integer.toString(length));
			parameters2.add(Integer.toString(length));
			parameters2.add(Boolean.toString(false));
			parameters2.add(Integer.toString(numSequences));
			parameters2.add(Boolean.toString(validEnd));
			CMDgenerateFixedLengthSequences cmd = new CMDgenerateFixedLengthSequences();
			cmd.run(parameters2);
			return;
		}

		IStochasticProcess model = null;
		Object dataObject = GlobalDataContainer.getInstance()
				.getData(modelname);
		if (dataObject == null) {
			CommandHelpers.objectNotFoundMessage(modelname);
			return;
		} else if (!(dataObject instanceof IStochasticProcess)) {
			CommandHelpers.objectNotType(modelname, "IStochasticProcess");
			return;
		}
		model = (IStochasticProcess) dataObject;
		
		HybridGenerator generator = new HybridGenerator(numSequences, length, maxLengthAll, validEnd);
		Collection<List<Event>> sequences = generator.generateTestSuite(model);
		
		if (GlobalDataContainer.getInstance().addData(sequencesName, sequences)) {
			CommandHelpers.dataOverwritten(sequencesName);
		}
		Console.println("" + sequences.size() + " sequences generated");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: generateHybrid <modelname> <sequencesName> <lenght> <maxlengthAll> <numSequences> {<validEnd>}");
	}

}
