package de.ugoe.cs.quest.plugin.mfc;

import de.ugoe.cs.quest.plugin.mfc.eventcore.WindowTree;
import de.ugoe.cs.quest.plugin.mfc.eventcore.WindowTreeNode;

/**
 * <p>
 * Handles {@code WM_SETTEXT} messages. Handler maintains the {@link WindowTree}.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class HandlerSetText extends MessageHandler {

	/**
	 * <p>
	 * Constructor. Creates a new HanderSetText.
	 * </p>
	 */
	public HandlerSetText() {
		super();
	}

	/**
	 * <p>
	 * New name of the window.
	 * </p>
	 */
	private String windowName;

	/**
	 * <p>
	 * HWND of the window.
	 * </p>
	 */
	private int hwnd;

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onEndElement()
	 */
	@Override
	public void onEndElement() {
		if (hwnd != 0) {
			WindowTreeNode node = WindowTree.getInstance().find(hwnd);
			node.setName(windowName);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.ugoe.cs.quest.plugin.mfc.MessageHandler#onParameter(java.lang.String
	 * , java.lang.String)
	 */
	@Override
	public void onParameter(String name, String value) {
		if (name.equals("window.hwnd")) {
			hwnd = Integer.parseInt(value);
		} else if (name.equals("window.newText")) {
			windowName = value;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.quest.plugin.mfc.MessageHandler#onStartElement()
	 */
	@Override
	public void onStartElement() {
		windowName = "";
		hwnd = 0;
	}
}
