/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.map.AbstractIntDoubleMap;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

class SelectedSparseDoubleMatrix1D
extends DoubleMatrix1D {
    protected AbstractIntDoubleMap elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedSparseDoubleMatrix1D(int n, AbstractIntDoubleMap abstractIntDoubleMap, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = abstractIntDoubleMap;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    protected SelectedSparseDoubleMatrix1D(AbstractIntDoubleMap abstractIntDoubleMap, int[] nArray) {
        this(nArray.length, abstractIntDoubleMap, 0, 1, nArray, 0);
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    public double getQuick(int n) {
        return this.elements.get(this.offset + this.offsets[this.zero + n * this.stride]);
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D instanceof SelectedSparseDoubleMatrix1D) {
            SelectedSparseDoubleMatrix1D selectedSparseDoubleMatrix1D = (SelectedSparseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == selectedSparseDoubleMatrix1D.elements;
        }
        if (doubleMatrix1D instanceof SparseDoubleMatrix1D) {
            SparseDoubleMatrix1D sparseDoubleMatrix1D = (SparseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == sparseDoubleMatrix1D.elements;
        }
        return false;
    }

    protected int index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public DoubleMatrix1D like(int n) {
        return new SparseDoubleMatrix1D(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return new SparseDoubleMatrix2D(n, n2);
    }

    public void setQuick(int n, double d) {
        int n2 = this.offset + this.offsets[this.zero + n * this.stride];
        if (d == 0.0) {
            this.elements.removeKey(n2);
        } else {
            this.elements.put(n2, d);
        }
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseDoubleMatrix1D(this.elements, nArray);
    }
}

