// Module    : $RCSfile: InteractionTask.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 06.11.2011 10:57:52 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011

package de.ugoe.cs.quest.tasktrees.treeimpl;

import de.ugoe.cs.quest.eventcore.IEventTarget;
import de.ugoe.cs.quest.eventcore.IEventType;
import de.ugoe.cs.quest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class EventTask extends TaskTreeNode implements IEventTask {
    
    /** */
    private IEventType eventType;

    /** */
    private IEventTarget eventTarget;

    /**
     * @param eventType
     * @param eventTarget
     */
    EventTask(IEventType eventType, IEventTarget eventTarget) {
        super(eventType.getName() + "(" + eventTarget + ")");
        super.setDescription(eventType + " on " + eventTarget);
        this.eventType = eventType;
        this.eventTarget = eventTarget;
    }

    /**
     * @return Returns the interaction.
     */
    public IEventType getEventType() {
        return eventType;
    }

    /**
     * @return Returns the GUIElement.
     */
    public IEventTarget getEventTarget() {
        return eventTarget;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.ctte.Task#equals(de.harms.ctte.Task)
     */
    @Override
    public boolean equals(ITaskTreeNode task) {
        if (!(task instanceof IEventTask)) {
            return false;
        }

        IEventType otherType = ((IEventTask) task).getEventType();
        IEventTarget otherTarget = ((IEventTask) task).getEventTarget();

        if (((eventType == otherType) ||
             ((eventType != null) && (eventType.equals(otherType)))) &&
            ((eventTarget == otherTarget) ||
             ((eventTarget != null) && (eventTarget.equals(otherTarget)))))
        {
            return true;
        }

        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.tasktrees.TreeNode#clone()
     */
    @Override
    public EventTask clone() {
        // Event type and target are unchangeable and do not need to be cloned
        return (EventTask) super.clone();
    }

}
