
package de.ugoe.cs.quest.plugin.jfc.eventcore;

import java.util.Map;

import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.IEventTarget;
import de.ugoe.cs.quest.eventcore.gui.IInteraction;

/**
 * <p>
 * This class defines JFC events.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class JFCEvent extends Event {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Internal map of parameters associated with the event.
     * </p>
     */
    private Map<String, String> parameters;

    /**
     * <p>
     * Information about the event source.
     * </p>
     */
    private Map<String, String> sourceParameters;

    /**
     * <p>
     * Information about the parent of the event source.
     * </p>
     */
    private Map<String, String> parentParameters;

    /**
     * <p>
     * Constructor. Creates a new JFCEvent.
     * </p>
     * 
     * @param type
     *            type of the event
     */
    public JFCEvent(IInteraction        type,
                    IEventTarget        target,
                    Map<String, String> parameters,
                    Map<String, String> sourceParameters,
                    Map<String, String> parentParameters)
    {
        super(type);
        super.setTarget(target);
        this.parameters = parameters;
        this.sourceParameters = sourceParameters;
        this.parentParameters = parentParameters;
    }

    /**
     * <p>
     * Retrieves the value of a parameter.
     * </p>
     * 
     * @param name
     *            name of the parameter
     * @return value of the parameter
     */
    public String getParameter(String name) {
        return parameters.get(name);
    }

    /**
     * <p>
     * Retrieves information about the source of the event.
     * </p>
     * 
     * @param name
     *            name of the information
     * @return value of the information
     */
    public String getSourceInformation(String name) {
        return sourceParameters.get(name);
    }

    /**
     * <p>
     * Retrieves information about the parent of the source of the event.
     * </p>
     * 
     * @param name
     *            name of the information
     * @return value of the information
     */
    public String getParentInformation(String name) {
        return parentParameters.get(name);
    }

}
