
package de.ugoe.cs.quest.plugin.mfc.eventcore;

import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.IEventType;
import de.ugoe.cs.quest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.quest.plugin.mfc.guimodel.MFCGUIElement;

/**
 * <p>
 * Contains all informations about a windows message, i.e., all parameters that are read when a
 * windows message is parsed as well as its target, hwnd, etc.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 * 
 */
public class MFCEvent extends Event {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param eventType
     * @param target
     * @param currentMessageParameters
     */
    public MFCEvent(IEventType    eventType,
                    MFCGUIElement target,
                    GUIModel      guiModel)
    {
        super(eventType);
        super.setTarget(target);
    }

    /**
     * <p>
     * Two {@link WindowsMessage} are equal, if their {@link #type}, {@link #xmlWindowDescription},
     * and {@link #params} are equal.
     * </p>
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        boolean isEqual = false;
        if (other instanceof MFCEvent) {
            isEqual =
                ((MFCEvent) other).type == this.type &&
                ((MFCEvent) other).target.equals(this.target);
        }
        return isEqual;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        int multiplier = 17;
        int hash = 42;

        hash = multiplier * hash + type.hashCode();
        hash = multiplier * hash + target.hashCode();

        return hash;
    }

}
