/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.PluggableRenderContext;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.picking.MultiPickedState;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import edu.uci.ics.jung.visualization.renderers.BasicRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.util.Caching;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicVisualizationServer<V, E>
extends JPanel
implements ChangeListener,
ChangeEventSupport,
VisualizationServer<V, E> {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected VisualizationModel<V, E> model;
    protected Renderer<V, E> renderer = new BasicRenderer();
    protected Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
    protected PickedState<V> pickedVertexState;
    protected PickedState<E> pickedEdgeState;
    protected ItemListener pickEventListener;
    protected BufferedImage offscreen;
    protected Graphics2D offscreenG2d;
    protected boolean doubleBuffered;
    protected List<VisualizationServer.Paintable> preRenderers = new ArrayList<VisualizationServer.Paintable>();
    protected List<VisualizationServer.Paintable> postRenderers = new ArrayList<VisualizationServer.Paintable>();
    protected RenderContext<V, E> renderContext = new PluggableRenderContext();

    public BasicVisualizationServer(Layout<V, E> layout) {
        this(new DefaultVisualizationModel<V, E>(layout));
    }

    public BasicVisualizationServer(Layout<V, E> layout, Dimension preferredSize) {
        this(new DefaultVisualizationModel<V, E>(layout, preferredSize), preferredSize);
    }

    public BasicVisualizationServer(VisualizationModel<V, E> model) {
        this(model, new Dimension(600, 600));
    }

    public BasicVisualizationServer(VisualizationModel<V, E> model, Dimension preferredSize) {
        this.model = model;
        model.addChangeListener(this);
        this.setDoubleBuffered(false);
        this.addComponentListener(new VisualizationListener(this));
        this.setPickSupport(new ShapePickSupport(this));
        this.setPickedVertexState(new MultiPickedState());
        this.setPickedEdgeState(new MultiPickedState());
        this.renderContext.setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer<E>(this.getPickedEdgeState(), Color.black, Color.cyan));
        this.renderContext.setVertexFillPaintTransformer(new PickableVertexPaintTransformer<V>(this.getPickedVertexState(), Color.red, Color.yellow));
        this.setPreferredSize(preferredSize);
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderContext.getMultiLayerTransformer().addChangeListener(this);
    }

    @Override
    public void setDoubleBuffered(boolean doubleBuffered) {
        this.doubleBuffered = doubleBuffered;
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    @Override
    public Dimension getSize() {
        Dimension d = super.getSize();
        if (d.width <= 0 || d.height <= 0) {
            d = this.getPreferredSize();
        }
        return d;
    }

    protected void checkOffscreenImage(Dimension d) {
        if (this.doubleBuffered && (this.offscreen == null || this.offscreen.getWidth() != d.width || this.offscreen.getHeight() != d.height)) {
            this.offscreen = new BufferedImage(d.width, d.height, 2);
            this.offscreenG2d = this.offscreen.createGraphics();
        }
    }

    @Override
    public VisualizationModel<V, E> getModel() {
        return this.model;
    }

    @Override
    public void setModel(VisualizationModel<V, E> model) {
        this.model = model;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
        this.fireStateChanged();
    }

    @Override
    public void setRenderer(Renderer<V, E> r) {
        this.renderer = r;
        this.repaint();
    }

    @Override
    public Renderer<V, E> getRenderer() {
        return this.renderer;
    }

    @Override
    public void setGraphLayout(Layout<V, E> layout) {
        Dimension viewSize = this.getPreferredSize();
        if (this.isShowing()) {
            viewSize = this.getSize();
        }
        this.model.setGraphLayout(layout, viewSize);
    }

    public void scaleToLayout(ScalingControl scaler) {
        Dimension ld;
        Dimension vd = this.getPreferredSize();
        if (this.isShowing()) {
            vd = this.getSize();
        }
        if (!vd.equals(ld = this.getGraphLayout().getSize())) {
            scaler.scale(this, (float)(vd.getWidth() / ld.getWidth()), new Point2D.Double());
        }
    }

    @Override
    public Layout<V, E> getGraphLayout() {
        return this.model.getGraphLayout();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            Dimension d = this.getSize();
            if (d.width <= 0 || d.height <= 0) {
                d = this.getPreferredSize();
            }
            this.model.getGraphLayout().setSize(d);
        }
    }

    @Override
    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void setRenderingHints(Map<RenderingHints.Key, Object> renderingHints) {
        this.renderingHints = renderingHints;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.doubleBuffered) {
            this.checkOffscreenImage(this.getSize());
            this.renderGraph(this.offscreenG2d);
            g2d.drawImage(this.offscreen, null, 0, 0);
        } else {
            this.renderGraph(g2d);
        }
    }

    protected void renderGraph(Graphics2D g2d) {
        if (this.renderContext.getGraphicsContext() == null) {
            this.renderContext.setGraphicsContext(new GraphicsDecorator(g2d));
        } else {
            this.renderContext.getGraphicsContext().setDelegate(g2d);
        }
        this.renderContext.setScreenDevice(this);
        Layout<V, E> layout = this.model.getGraphLayout();
        g2d.setRenderingHints(this.renderingHints);
        Dimension d = this.getSize();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, d.width, d.height);
        AffineTransform oldXform = g2d.getTransform();
        AffineTransform newXform = new AffineTransform(oldXform);
        newXform.concatenate(this.renderContext.getMultiLayerTransformer().getTransformer(Layer.VIEW).getTransform());
        g2d.setTransform(newXform);
        for (VisualizationServer.Paintable paintable : this.preRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        if (layout instanceof Caching) {
            ((Caching)layout).clear();
        }
        this.renderer.render(this.renderContext, layout);
        for (VisualizationServer.Paintable paintable : this.postRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        g2d.setTransform(oldXform);
    }

    @Override
    public void addPreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers == null) {
            this.preRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.preRenderers.add(paintable);
    }

    public void prependPreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers == null) {
            this.preRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.preRenderers.add(0, paintable);
    }

    @Override
    public void removePreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers != null) {
            this.preRenderers.remove(paintable);
        }
    }

    @Override
    public void addPostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers == null) {
            this.postRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.postRenderers.add(paintable);
    }

    public void prependPostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers == null) {
            this.postRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.postRenderers.add(0, paintable);
    }

    @Override
    public void removePostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers != null) {
            this.postRenderers.remove(paintable);
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    @Override
    public PickedState<V> getPickedVertexState() {
        return this.pickedVertexState;
    }

    @Override
    public PickedState<E> getPickedEdgeState() {
        return this.pickedEdgeState;
    }

    @Override
    public void setPickedVertexState(PickedState<V> pickedVertexState) {
        if (this.pickEventListener != null && this.pickedVertexState != null) {
            this.pickedVertexState.removeItemListener(this.pickEventListener);
        }
        this.pickedVertexState = pickedVertexState;
        this.renderContext.setPickedVertexState(pickedVertexState);
        if (this.pickEventListener == null) {
            this.pickEventListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    BasicVisualizationServer.this.repaint();
                }
            };
        }
        pickedVertexState.addItemListener(this.pickEventListener);
    }

    @Override
    public void setPickedEdgeState(PickedState<E> pickedEdgeState) {
        if (this.pickEventListener != null && this.pickedEdgeState != null) {
            this.pickedEdgeState.removeItemListener(this.pickEventListener);
        }
        this.pickedEdgeState = pickedEdgeState;
        this.renderContext.setPickedEdgeState(pickedEdgeState);
        if (this.pickEventListener == null) {
            this.pickEventListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    BasicVisualizationServer.this.repaint();
                }
            };
        }
        pickedEdgeState.addItemListener(this.pickEventListener);
    }

    @Override
    public GraphElementAccessor<V, E> getPickSupport() {
        return this.renderContext.getPickSupport();
    }

    @Override
    public void setPickSupport(GraphElementAccessor<V, E> pickSupport) {
        this.renderContext.setPickSupport(pickSupport);
    }

    @Override
    public Point2D getCenter() {
        Dimension d = this.getSize();
        return new Point2D.Float(d.width / 2, d.height / 2);
    }

    @Override
    public RenderContext<V, E> getRenderContext() {
        return this.renderContext;
    }

    @Override
    public void setRenderContext(RenderContext<V, E> renderContext) {
        this.renderContext = renderContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class VisualizationListener
    extends ComponentAdapter {
        protected BasicVisualizationServer<V, E> vv;

        public VisualizationListener(BasicVisualizationServer<V, E> vv) {
            this.vv = vv;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension d = this.vv.getSize();
            if (d.width <= 0 || d.height <= 0) {
                return;
            }
            BasicVisualizationServer.this.checkOffscreenImage(d);
            BasicVisualizationServer.this.repaint();
        }
    }
}

