// Module    : $RCSfile: TaskTreeManagerTest.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 08.11.2011 21:32:36 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011

package de.ugoe.cs.quest.tasktrees.manager;

import java.util.logging.Logger;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.IEventTarget;
import de.ugoe.cs.quest.eventcore.IEventType;
import de.ugoe.cs.quest.tasktrees.testutils.DummyGUIElement;
import de.ugoe.cs.quest.tasktrees.testutils.DummyInteraction;
import de.ugoe.cs.quest.tasktrees.testutils.SimpleLogFormatter;
import de.ugoe.cs.quest.tasktrees.testutils.TaskTreeChecker;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class TaskTreeManagerTest {
    
    /** */
    TaskTreeManager manager;

    /**
     *
     */
    @Before
    public void setUp() {
        Logger.getLogger("").getHandlers()[0].setFormatter(new SimpleLogFormatter());

        manager = new TaskTreeManager();
    }

    /**
     *
     */
    @After
    public void tearDown() {
        manager = null;
        ComponentManager.clearInstance();
    }

    /**
     *
     */
    @Test
    public void testOneEventOnOneElement() {
        simulateEvent(new DummyInteraction("bla", 1), new DummyGUIElement("elem1"));
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event bla {}" +
             "}", manager.getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testManyEventsOnOneElement() {
        IEventTarget eventTarget = new DummyGUIElement("elem1");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget);
        simulateEvent(new DummyInteraction("blu", 1), eventTarget);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence {" +
             "  Event bla {}" +
             "  Event bli {}" +
             "  Event blo {}" +
             "  Event blu {}" +
             "  Event bla {}" +
             "}", manager.getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testOneEventOnManyElements() {
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        IEventTarget eventTarget3 = new DummyGUIElement("elem3");
        IEventTarget eventTarget4 = new DummyGUIElement("elem4");
        IEventTarget eventTarget5 = new DummyGUIElement("elem5");
        IEventTarget eventTarget6 = new DummyGUIElement("elem6");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget2);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget3);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget5);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget6);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bli {}" +
             "  }" +
             "  Sequence sequence3 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence4 {" +
             "    Event bli {}" +
             "  }" +
             "  Sequence sequence5 {" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence6 {" +
             "    Event bla {}" +
             "  }" +
             "}", manager.getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testManyEventsOnManyElements() {
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");
        IEventTarget eventTarget3 = new DummyGUIElement("elem3");
        IEventTarget eventTarget4 = new DummyGUIElement("elem4");
        IEventTarget eventTarget5 = new DummyGUIElement("elem5");
        IEventTarget eventTarget6 = new DummyGUIElement("elem6");
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget1);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget2);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget2);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget3);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget4);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget4);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget5);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget6);
        simulateEvent(new DummyInteraction("bla", 1), eventTarget6);
        simulateEvent(new DummyInteraction("bli", 1), eventTarget6);
        simulateEvent(new DummyInteraction("blo", 1), eventTarget6);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Sequence sequence1 {" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence2 {" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence3 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence4 {" +
             "    Event bli {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "  Sequence sequence5 {" +
             "    Event bla {}" +
             "  }" +
             "  Sequence sequence6 {" +
             "    Event bli {}" +
             "    Event bla {}" +
             "    Event bli {}" +
             "    Event blo {}" +
             "  }" +
             "}", manager.getTaskTree());
    }

    /**
     *
     */
    @Test
    public void testEventIterationDetection() throws Exception {
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        IEventType event1 = new DummyInteraction("bla", 1);
        simulateEvent(event1, eventTarget1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Event bla {}" +
             "}", manager.getTaskTree());

        simulateEvent(event1, eventTarget1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", manager.getTaskTree());

        simulateEvent(event1, eventTarget1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", manager.getTaskTree());

        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, eventTarget1);
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "}", manager.getTaskTree());

        // now test with preceding and trailing other interactions
        IEventType event2 = new DummyInteraction("bli", 1);
        IEventType event3 = new DummyInteraction("blup", 1);

        simulateEvent(event2, eventTarget1);
        simulateEvent(event3, eventTarget1);
        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, eventTarget1);
        }
        simulateEvent(event3, eventTarget1);
        simulateEvent(event2, eventTarget1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "  Event bli {}" +
             "  Event blup {}" +
             "  Iteration iteration2 {" +
             "    Event bla {}" +
             "  }" +
             "  Event blup {}" +
             "  Event bli {}" +
             "}", manager.getTaskTree());

        // now test with iterations of iterations

        for (int i = 0; i < 10; i++) {
            for (int j = 0; j < 5; j++) {
                simulateEvent(event1, eventTarget1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event2, eventTarget1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event3, eventTarget1);
            }
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence0 {" +
             "  Iteration iteration0 {" +
             "    Event bla {}" +
             "  }" +
             "  Event bli {}" +
             "  Event blup {}" +
             "  Iteration iteration1 {" +
             "    Event bla {}" +
             "  }" +
             "  Event blup {}" +
             "  Event bli {}" +
             "  Iteration iteration2 {" +
             "    Sequence sequence1 {" +
             "      Iteration iteration3 {" +
             "        Event bla {}" +
             "      }" +
             "      Iteration iteration4 {" +
             "        Event bli {}" +
             "      }" +
             "      Iteration iteration5 {" +
             "        Event blup {}" +
             "      }" +
             "    }" +
             "  }" +
             "}", manager.getTaskTree());

    }

    /**
     *
     */
    @Test
    public void testSequenceIterationDetection() throws Exception {
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");
        IEventType event1 = new DummyInteraction("bla", 1);
        IEventType event2 = new DummyInteraction("bli", 1);
        IEventType event3 = new DummyInteraction("blup", 1);
        simulateEvent(event1, eventTarget1);
        simulateEvent(event2, eventTarget1);
        simulateEvent(event3, eventTarget1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Event bla {}" +
             "  Event bli {}" +
             "  Event blup {}" +
             "}", manager.getTaskTree());

        simulateEvent(event1, eventTarget1);
        simulateEvent(event2, eventTarget1);
        simulateEvent(event3, eventTarget1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "}", manager.getTaskTree());

        simulateEvent(event1, eventTarget1);
        simulateEvent(event2, eventTarget1);
        simulateEvent(event3, eventTarget1);
        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "}", manager.getTaskTree());

        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, eventTarget1);
            simulateEvent(event2, eventTarget1);
            simulateEvent(event3, eventTarget1);
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "}", manager.getTaskTree());

        // now test with preceding and trailing other interactions
        IEventType event4 = new DummyInteraction("ble", 1);
        IEventType event5 = new DummyInteraction("blo", 1);
        IEventType event6 = new DummyInteraction("blu", 1);
        simulateEvent(event4, eventTarget1);
        simulateEvent(event5, eventTarget1);
        simulateEvent(event6, eventTarget1);
        for (int i = 0; i < 10; i++) {
            simulateEvent(event1, eventTarget1);
            simulateEvent(event2, eventTarget1);
            simulateEvent(event3, eventTarget1);
        }
        simulateEvent(event6, eventTarget1);
        simulateEvent(event5, eventTarget1);
        simulateEvent(event4, eventTarget1);

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "  Event ble {}" +
             "  Event blo {}" +
             "  Event blu {}" +
             "  Iteration iteration2 {" +
             "    Sequence sequence3 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "  Event blu {}" +
             "  Event blo {}" +
             "  Event ble {}" +
             "}", manager.getTaskTree());

        // now test with iterations of iterations
        for (int i = 0; i < 10; i++) {
            for (int j = 0; j < 5; j++) {
                simulateEvent(event1, eventTarget1);
                simulateEvent(event2, eventTarget1);
                simulateEvent(event3, eventTarget1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event2, eventTarget1);
                simulateEvent(event1, eventTarget1);
                simulateEvent(event3, eventTarget1);
            }
            for (int j = 0; j < 5; j++) {
                simulateEvent(event1, eventTarget1);
                simulateEvent(event2, eventTarget1);
                simulateEvent(event3, eventTarget1);
            }
        }

        new TaskTreeChecker().assertTaskTree
            ("Sequence sequence1 {" +
             "  Iteration iteration1 {" +
             "    Sequence sequence2 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "  Event ble {}" +
             "  Event blo {}" +
             "  Event blu {}" +
             "  Iteration iteration2 {" +
             "    Sequence sequence3 {" +
             "      Event bla {}" +
             "      Event bli {}" +
             "      Event blup {}" +
             "    }" +
             "  }" +
             "  Event blu {}" +
             "  Event blo {}" +
             "  Event ble {}" +
             "  Iteration iteration3 {" +
             "    Sequence sequence4 {" +
             "      Iteration iteration4 {" +
             "        Sequence sequence4 {" +
             "          Event bla {}" +
             "          Event bli {}" +
             "          Event blup {}" +
             "        }" +
             "      }" +
             "      Iteration iteration5 {" +
             "        Sequence sequence5 {" +
             "          Event bli {}" +
             "          Event bla {}" +
             "          Event blup {}" +
             "        }" +
             "      }" +
             "      Iteration iteration6 {" +
             "        Sequence sequence6 {" +
             "          Event bla {}" +
             "          Event bli {}" +
             "          Event blup {}" +
             "        }" +
             "      }" +
             "    }" +
             "  }" +
             "}", manager.getTaskTree());
    }

    /**
     *
     */
    private void simulateEvent(IEventType eventType, IEventTarget eventTarget) {
        manager.handleNewEvent(new Event(eventType, eventTarget));
    }

}
