/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plan;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisPass {
    private LinkedList<DetectorFactory> orderedFactoryList = new LinkedList();
    private HashSet<DetectorFactory> memberSet = new HashSet();

    public void addToPass(DetectorFactory factory) {
        this.memberSet.add(factory);
    }

    public void append(DetectorFactory factory) {
        if (!this.memberSet.contains(factory)) {
            throw new IllegalArgumentException("Detector " + factory.getFullName() + " appended to pass it doesn't belong to");
        }
        this.orderedFactoryList.addLast(factory);
    }

    public Collection<DetectorFactory> getMembers() {
        return this.memberSet;
    }

    public Set<DetectorFactory> getUnpositionedMembers() {
        HashSet<DetectorFactory> result = new HashSet<DetectorFactory>(this.memberSet);
        result.removeAll(this.orderedFactoryList);
        return result;
    }

    public Iterator<DetectorFactory> iterator() {
        return this.orderedFactoryList.iterator();
    }

    public boolean contains(DetectorFactory factory) {
        return this.memberSet.contains(factory);
    }

    public Detector2[] instantiateDetector2sInPass(BugReporter bugReporter) {
        Detector2[] detectorList = new Detector2[this.orderedFactoryList.size()];
        int count = 0;
        Iterator<DetectorFactory> j = this.iterator();
        while (j.hasNext()) {
            detectorList[count++] = j.next().createDetector2(bugReporter);
        }
        return detectorList;
    }

    @Deprecated
    public Detector[] instantiateDetectorsInPass(BugReporter bugReporter) {
        int count = 0;
        for (DetectorFactory factory : this.orderedFactoryList) {
            if (!factory.isDetectorClassSubtypeOf(Detector.class)) continue;
            ++count;
        }
        Detector[] detectorList = new Detector[count];
        count = 0;
        for (DetectorFactory factory : this.orderedFactoryList) {
            if (!factory.isDetectorClassSubtypeOf(Detector.class)) continue;
            detectorList[count++] = factory.create(bugReporter);
        }
        return detectorList;
    }
}

