/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.set;

import java.util.Comparator;
import java.util.SortedSet;
import org.apache.commons.collections15.collection.SynchronizedCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedSortedSet<E>
extends SynchronizedCollection<E>
implements SortedSet<E> {
    private static final long serialVersionUID = 2775582861954500111L;

    public static <E> SortedSet<E> decorate(SortedSet<E> set) {
        return new SynchronizedSortedSet<E>(set);
    }

    protected SynchronizedSortedSet(SortedSet<E> set) {
        super(set);
    }

    protected SynchronizedSortedSet(SortedSet<E> set, Object lock) {
        super(set, lock);
    }

    protected SortedSet<E> getSortedSet() {
        return (SortedSet)this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        Object object = this.lock;
        synchronized (object) {
            SortedSet<E> set = this.getSortedSet().subSet(fromElement, toElement);
            return new SynchronizedSortedSet<E>(set, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<E> headSet(E toElement) {
        Object object = this.lock;
        synchronized (object) {
            SortedSet<E> set = this.getSortedSet().headSet(toElement);
            return new SynchronizedSortedSet<E>(set, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<E> tailSet(E fromElement) {
        Object object = this.lock;
        synchronized (object) {
            SortedSet<E> set = this.getSortedSet().tailSet(fromElement);
            return new SynchronizedSortedSet<E>(set, this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E first() {
        Object object = this.lock;
        synchronized (object) {
            return this.getSortedSet().first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E last() {
        Object object = this.lock;
        synchronized (object) {
            return this.getSortedSet().last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Comparator<? super E> comparator() {
        Object object = this.lock;
        synchronized (object) {
            return this.getSortedSet().comparator();
        }
    }
}

