
package de.ugoe.cs.quest.plugin.php.eventcore;

import de.ugoe.cs.quest.eventcore.IEventTarget;

/**
 * <p>
 * Event target for PHP web requests.
 * </p>
 * 
 * @version $Revision: $ $Date: Aug 16, 2012$
 * @author 2012, last modified by $Author: sherbold$
 */
public class PHPEventTarget implements IEventTarget {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Path of the PHP request.
     * </p>
     */
    private String path;

    /**
     * <p>
     * Constructor. Creates a new PHP event target as the path of the request.
     * </p>
     * 
     * @param path
     *            path of the URI of the event
     */
    public PHPEventTarget(String path) {
        this.path = path;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.quest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "PHP";
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return path;
    }

}
