
package de.ugoe.cs.quest.ui.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;

import de.ugoe.cs.quest.ui.GlobalDataContainer;
import de.ugoe.cs.quest.usageprofiles.FirstOrderMarkovModel;
import de.ugoe.cs.quest.usageprofiles.IDotCompatible;
import de.ugoe.cs.quest.usageprofiles.IStochasticProcess;
import de.ugoe.cs.util.console.CommandExecuter;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public class ModelsTabComposite extends Composite {

    List modelList;

    /**
     * Create the composite.
     * 
     * @param parent
     * @param style
     */
    public ModelsTabComposite(Composite parent, int style) {
        super(parent, style);
        createContents();
    }

    private void createContents() {
        setLayout(new GridLayout(5, false));

        modelList = new List(this, SWT.BORDER | SWT.V_SCROLL);
        modelList.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1));

        Button btnShow = new Button(this, SWT.NONE);
        btnShow.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] selectedStrings = modelList.getSelection();
                if (selectedStrings.length == 0) {
                    SWTHelpers.noSelectionError(getShell());
                    return;
                }
                IStochasticProcess process =
                    (IStochasticProcess) GlobalDataContainer.getInstance()
                        .getData(selectedStrings[0]);
                if (process instanceof FirstOrderMarkovModel) {
                    String command = "showMarkovModel " + selectedStrings[0];
                    CommandExecuter.getInstance().exec(command);
                }
                else {
                    MessageBox messageBox = new MessageBox(getShell(), SWT.NONE);
                    messageBox.setText("Feature Not Available");
                    messageBox
                        .setMessage("The feature is currently only available for first-order Markov models.");
                    messageBox.open();
                }
            }
        });
        btnShow.setText("Visualize");

        Button btnDelete_1 = new Button(this, SWT.NONE);
        btnDelete_1.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                if (SWTHelpers.deleteSelectedFromStorage(modelList)) {
                    updateModelList();
                }
                else {
                    SWTHelpers.noSelectionError(getShell());
                }
            }
        });
        btnDelete_1.setText("Delete");

        Button btnGenSequences = new Button(this, SWT.NONE);
        btnGenSequences.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] selectedStrings = modelList.getSelection();
                if (selectedStrings.length == 0) {
                    SWTHelpers.noSelectionError(getShell());
                    return;
                }
                GenerateSequencesDialog generateSequencesDialog =
                    new GenerateSequencesDialog(getShell(), SWT.NONE);
                generateSequencesDialog.setProcessName(selectedStrings[0]);
                generateSequencesDialog.open();
            }
        });
        btnGenSequences.setText("Gen. Sequences");

        Button btnProperties = new Button(this, SWT.NONE);
        btnProperties.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] selectedStrings = modelList.getSelection();
                if (selectedStrings.length == 0) {
                    SWTHelpers.noSelectionError(getShell());
                    return;
                }
                IStochasticProcess process =
                    (IStochasticProcess) GlobalDataContainer.getInstance()
                        .getData(selectedStrings[0]);
                ModelPropertiesDialog modelPropertiesDialog =
                    new ModelPropertiesDialog(getShell(), SWT.NONE);
                modelPropertiesDialog.setStochasticProcess(process);
                modelPropertiesDialog.open();
            }
        });
        btnProperties.setText("Properties");

        Button btnCreateDot = new Button(this, SWT.NONE);
        btnCreateDot.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                String[] selectedStrings = modelList.getSelection();
                if (selectedStrings.length == 0) {
                    SWTHelpers.noSelectionError(getShell());
                    return;
                }
                IStochasticProcess process =
                    (IStochasticProcess) GlobalDataContainer.getInstance()
                        .getData(selectedStrings[0]);
                String command = "";
                if (process instanceof IDotCompatible) {
                    command = "printDot ";
                }
                else {
                    command = "printTrieDot ";
                }
                command += selectedStrings[0];
                CommandExecuter.getInstance().exec(command);
            }
        });
        btnCreateDot.setText("Create DOT");
    }

    @Override
    protected void checkSubclass() {
        // Disable the check that prevents subclassing of SWT components
    }

    public void updateModelList() {
        modelList.removeAll();
        for (String sequencesName : GlobalDataContainer.getInstance().getAllModelNames()) {
            modelList.add(sequencesName);
        }
    }

}
