/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.config.CommandLine;
import java.io.IOException;
import java.util.HashSet;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionResults {
    public static SortedBugCollection union(SortedBugCollection origCollection, SortedBugCollection newCollection) {
        SortedBugCollection result = origCollection.duplicate();
        UnionResults.merge(null, result, newCollection);
        return result;
    }

    public static void merge(HashSet<String> hashes, SortedBugCollection into, SortedBugCollection from) {
        for (BugInstance bugInstance : from.getCollection()) {
            if (hashes != null && !hashes.add(bugInstance.getInstanceHash())) continue;
            into.add(bugInstance);
        }
        ProjectStats stats = into.getProjectStats();
        ProjectStats stats2 = from.getProjectStats();
        stats.addStats(stats2);
        Project project = into.getProject();
        Project project2 = from.getProject();
        project.add(project2);
        for (AnalysisError analysisError : from.getErrors()) {
            into.addError(analysisError);
        }
    }

    public static void main(String[] argv) throws IOException {
        FindBugs.setNoAnalysis();
        UnionResultsCommandLine commandLine = new UnionResultsCommandLine();
        int argCount = commandLine.parse(argv, 2, Integer.MAX_VALUE, "Usage: " + UnionResults.class.getName() + " [options] [<results1> <results2> ... <resultsn>] ");
        SortedBugCollection results = null;
        HashSet<String> hashes = new HashSet<String>();
        for (int i = argCount; i < argv.length; ++i) {
            try {
                SortedBugCollection more = new SortedBugCollection();
                more.readXML(argv[i]);
                if (results != null) {
                    UnionResults.merge(hashes, results, more);
                    continue;
                }
                results = more;
                for (BugInstance b : more.getCollection()) {
                    hashes.add(b.getInstanceHash());
                }
                continue;
            }
            catch (IOException e) {
                System.err.println("Trouble reading/parsing " + argv[i]);
                continue;
            }
            catch (DocumentException e) {
                System.err.println("Trouble reading/parsing " + argv[i]);
            }
        }
        if (results == null) {
            System.err.println("No files successfully read");
            System.exit(1);
            return;
        }
        results.setWithMessages(commandLine.withMessages);
        if (commandLine.outputFile == null) {
            results.writeXML(System.out);
        } else {
            results.writeXML(commandLine.outputFile);
        }
    }

    static {
        DetectorFactoryCollection.instance();
    }

    static class UnionResultsCommandLine
    extends CommandLine {
        public String outputFile;
        boolean withMessages;

        UnionResultsCommandLine() {
            this.addSwitch("-withMessages", "Generated XML should contain msgs for external processing");
            this.addOption("-output", "outputFile", "File in which to store combined results");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (!option.equals("-withMessages")) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.withMessages = true;
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (!option.equals("-output")) {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
            this.outputFile = argument;
        }
    }
}

