/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.gui2.AnalysisCallback;
import edu.umd.cs.findbugs.gui2.BugLoader;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.ProjectSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public final class AnalyzingDialog
extends FBDialog
implements FindBugsProgress {
    private volatile boolean analysisFinished = false;
    @Nonnull
    private Project project;
    private AnalysisCallback callback;
    private AnalysisThread analysisThread = new AnalysisThread();
    private int count;
    private int goal;
    private JLabel statusLabel;
    private JProgressBar progressBar;
    private JButton cancelButton;
    int pass = 0;
    int[] classesPerPass;

    public AnalyzingDialog(final @Nonnull Project project, final boolean changeSettings) {
        this(project, new AnalysisCallback(){

            public void analysisFinished(BugCollection results) {
                if (changeSettings) {
                    ProjectSettings.newInstance();
                }
                MainFrame instance = MainFrame.getInstance();
                assert (results.getProject() == project);
                instance.setBugCollection(results);
                try {
                    instance.releaseDisplayWait();
                }
                catch (Exception e) {
                    Logger.getLogger(AnalyzingDialog.class.getName()).log(Level.FINE, "", e);
                }
                results.reinitializeCloud();
            }

            public void analysisInterrupted() {
                MainFrame instance = MainFrame.getInstance();
                instance.updateProjectAndBugCollection(null);
                instance.releaseDisplayWait();
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalyzingDialog(@Nonnull Project project, AnalysisCallback callback, boolean joinThread) {
        if (project == null) {
            throw new NullPointerException("null project");
        }
        this.project = project;
        this.callback = callback;
        this.initComponents();
        MainFrame.getInstance().acquireDisplayWait();
        try {
            this.analysisThread.start();
            if (joinThread) {
                try {
                    this.analysisThread.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        finally {
            MainFrame.getInstance().releaseDisplayWait();
        }
    }

    public void initComponents() {
        this.statusLabel = new JLabel(" ");
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.cancelButton = new JButton(L10N.getLocalString("dlg.cancel_btn", "Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalyzingDialog.this.cancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                AnalyzingDialog.this.cancel();
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnalyzingDialog.this.setLayout(new BoxLayout(AnalyzingDialog.this.getContentPane(), 1));
                AnalyzingDialog.this.add(AnalyzingDialog.this.statusLabel);
                AnalyzingDialog.this.add(AnalyzingDialog.this.progressBar);
                AnalyzingDialog.this.add(AnalyzingDialog.this.cancelButton);
                AnalyzingDialog.this.statusLabel.setAlignmentX(0.5f);
                AnalyzingDialog.this.progressBar.setAlignmentX(0.5f);
                AnalyzingDialog.this.cancelButton.setAlignmentX(0.5f);
                AnalyzingDialog.this.pack();
                AnalyzingDialog.this.setSize(300, AnalyzingDialog.this.getHeight());
                AnalyzingDialog.this.setLocationRelativeTo(MainFrame.getInstance());
                AnalyzingDialog.this.setResizable(false);
                AnalyzingDialog.this.setModal(true);
                AnalyzingDialog.this.setVisible(true);
            }
        });
    }

    private void cancel() {
        if (!this.analysisFinished) {
            this.analysisThread.interrupt();
            this.setVisible(false);
        }
    }

    private void updateStage(String stage) {
        this.statusLabel.setText(stage);
    }

    private void incrementCount() {
        ++this.count;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnalyzingDialog.this.progressBar.setString(AnalyzingDialog.this.count + "/" + AnalyzingDialog.this.goal);
                AnalyzingDialog.this.progressBar.setValue(AnalyzingDialog.this.count);
            }
        });
    }

    private void updateCount(final int count, final int goal) {
        this.count = count;
        this.goal = goal;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnalyzingDialog.this.progressBar.setString(count + "/" + goal);
                AnalyzingDialog.this.progressBar.setValue(count);
                AnalyzingDialog.this.progressBar.setMaximum(goal);
            }
        });
    }

    public void finishArchive() {
        this.incrementCount();
    }

    public void finishClass() {
        this.incrementCount();
    }

    public void finishPerClassAnalysis() {
        this.updateStage(L10N.getLocalString("progress.finishing_analysis", "Finishing analysis..."));
    }

    public void reportNumberOfArchives(int numArchives) {
        this.updateStage(L10N.getLocalString("progress.scanning_archives", "Scanning archives..."));
        this.updateCount(0, numArchives);
    }

    public void startAnalysis(int numClasses) {
        ++this.pass;
        String localString = L10N.getLocalString("progress.analyzing_classes", "Analyzing classes...");
        this.updateStage(localString + ", pass " + this.pass + "/" + this.classesPerPass.length);
        this.updateCount(0, numClasses);
    }

    public void predictPassCount(int[] classesPerPass) {
        this.classesPerPass = classesPerPass;
    }

    public void startArchive(String name) {
    }

    private class AnalysisThread
    extends Thread {
        private AnalysisThread() {
            this.setPriority(Driver.getPriority());
            this.setName("Analysis Thread");
        }

        public void run() {
            BugCollection data;
            if (AnalyzingDialog.this.project == null) {
                throw new NullPointerException("null project");
            }
            try {
                data = BugLoader.doAnalysis(AnalyzingDialog.this.project, AnalyzingDialog.this);
            }
            catch (InterruptedException e) {
                AnalyzingDialog.this.callback.analysisInterrupted();
                return;
            }
            catch (IOException e) {
                AnalyzingDialog.this.callback.analysisInterrupted();
                this.scheduleDialogCleanup();
                this.scheduleErrorDialog("Analysis failed", e.getMessage());
                return;
            }
            AnalyzingDialog.this.analysisFinished = true;
            this.scheduleDialogCleanup();
            AnalyzingDialog.this.callback.analysisFinished(data);
            MainFrame.getInstance().newProject();
        }

        private void scheduleDialogCleanup() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AnalyzingDialog.this.setVisible(false);
                }
            });
        }

        private void scheduleErrorDialog(final String title, final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), message, title, 0);
                }
            });
        }
    }
}

