// Module    : $RCSfile: ComponentManager.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 12.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012

package de.ugoe.cs.quest.tasktrees.manager;

import de.ugoe.cs.quest.tasktrees.nodeequality.NodeEqualityRuleManager;
import de.ugoe.cs.quest.tasktrees.temporalrelation.TemporalRelationshipRuleManager;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNodeFactory;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeBuilder;
import de.ugoe.cs.quest.tasktrees.treeimpl.TaskTreeNodeFactory;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 12.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public class ComponentManager {
    
    /** */
    private static ComponentManager instance;

    /** */
    private TemporalRelationshipRuleManager temporalRelationshipRuleManager;

    /** */
    private NodeEqualityRuleManager nodeEqualityRuleManager;

    /** */
    private ITaskTreeBuilder taskTreeBuilder;

    /** */
    private ITaskTreeNodeFactory taskTreeNodeFactory;

    /**
     * TODO: comment
     * 
     * @return
     */
    public static TemporalRelationshipRuleManager getTemporalRelationshipRuleManager() {
        return getInstance().temporalRelationshipRuleManager;
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    public static NodeEqualityRuleManager getNodeEqualityRuleManager() {
        return getInstance().nodeEqualityRuleManager;
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    public static ITaskTreeBuilder getDefaultTaskTreeBuilder() {
        return getInstance().taskTreeBuilder;
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    public static ITaskTreeNodeFactory getDefaultTaskTreeNodeFactory() {
        return getInstance().taskTreeNodeFactory;
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    public static synchronized void clearInstance() {
        instance = null;
    }

    /**
     * TODO: comment
     * 
     * @return
     */
    private static synchronized ComponentManager getInstance() {
        if (instance == null) {
            instance = new ComponentManager();
            instance.init();
        }
        return instance;
    }

    /**
     * TODO: comment
     * 
     */
    private void init() {
        nodeEqualityRuleManager = new NodeEqualityRuleManager();
        nodeEqualityRuleManager.init();

        temporalRelationshipRuleManager =
            new TemporalRelationshipRuleManager(nodeEqualityRuleManager);
        temporalRelationshipRuleManager.init();

        taskTreeBuilder = new TaskTreeBuilder();
        taskTreeNodeFactory = new TaskTreeNodeFactory();
    }

}
