package de.ugoe.cs.util.console.defaultcommands;

import java.util.ArrayList;
import java.util.List;
import org.junit.*;

import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.mock.MockCommandListener;
import de.ugoe.cs.util.console.mock.MockOutputListener;
import de.ugoe.cs.util.console.mock.MockTraceListener;
import static org.junit.Assert.*;

/**
 * The class <code>CMDexecTest</code> contains tests for the class
 * <code>{@link CMDexec}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class CMDexecTest {

	final static String ENDLINE = System.getProperty("line.separator");

	@Test
	public void testHelp_1() throws Exception {
		CMDexec fixture = new CMDexec();
		MockOutputListener mockListener = new MockOutputListener();
		Console.getInstance().registerOutputListener(mockListener);
		String expected = "Usage: exec <filename>" + ENDLINE;

		fixture.help();

		assertEquals(expected, mockListener.getLastOutput());
	}

	@Test
	public void testRun_1() throws Exception {
		CMDexec fixture = new CMDexec();
		MockCommandListener mockCommandListener = new MockCommandListener();
		MockTraceListener mockTraceListener = new MockTraceListener();
		Console.getInstance().registerCommandListener(mockCommandListener);
		Console.getInstance().registerTraceListener(mockTraceListener);
		List<Object> parameters = new ArrayList<Object>();
		parameters
				.add("testdata/de.ugoe.cs.util.console.defaultcommands.CMDexecTest/script1");
		String exepctedCommand = "mockCommand";
		String expectedTrace = "Executing \"mockCommand\"";

		fixture.run(parameters);

		assertEquals(exepctedCommand, mockCommandListener.getLastCommand());
		assertEquals(expectedTrace + ENDLINE, mockTraceListener.getLastTrace());
	}

	@Test
	public void testRun_2() throws Exception {
		CMDexec fixture = new CMDexec();
		MockCommandListener mockCommandListener = new MockCommandListener();
		MockTraceListener mockTraceListener = new MockTraceListener();
		Console.getInstance().registerCommandListener(mockCommandListener);
		Console.getInstance().registerTraceListener(mockTraceListener);
		List<Object> parameters = new ArrayList<Object>();
		parameters
				.add("testdata/de.ugoe.cs.util.console.defaultcommands.CMDexecTest/script2");
		String expectedCommand = "mockCommand param1";
		String expectedTrace = "Executing \"mockCommand param1\"";

		fixture.run(parameters);

		assertEquals(expectedCommand, mockCommandListener.getLastCommand());
		assertEquals(expectedTrace + ENDLINE, mockTraceListener.getLastTrace());
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testRun_3() throws Exception {
		CMDexec fixture = new CMDexec();
		MockCommandListener mockCommandListener = new MockCommandListener();
		MockTraceListener mockTraceListener = new MockTraceListener();
		Console.getInstance().registerCommandListener(mockCommandListener);
		Console.getInstance().registerTraceListener(mockTraceListener);
		List<Object> parameters = new ArrayList<Object>();

		fixture.run(parameters);
	}

	@Test
	public void testRun_4() throws Exception {
		CMDexec fixture = new CMDexec();
		MockCommandListener mockCommandListener = new MockCommandListener();
		MockTraceListener mockTraceListener = new MockTraceListener();
		Console.getInstance().registerCommandListener(mockCommandListener);
		Console.getInstance().registerTraceListener(mockTraceListener);
		List<Object> parameters = new ArrayList<Object>();
		parameters
				.add("testdata/de.ugoe.cs.util.console.defaultcommands.CMDexecTest/script2");
		parameters.add(Integer.parseInt("1"));
		String expectedCommand = "mockCommand param1";
		String expectedTrace = "Executing \"mockCommand param1\"";

		fixture.run(parameters);

		assertEquals(expectedCommand, mockCommandListener.getLastCommand());
		assertEquals(expectedTrace + ENDLINE, mockTraceListener.getLastTrace());
	}

	@Test(expected = java.security.InvalidParameterException.class)
	public void testRun_5() throws Exception {
		CMDexec fixture = new CMDexec();
		List<Object> parameters = new ArrayList<Object>();
		parameters.add(Integer.parseInt("1"));

		fixture.run(parameters);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(CMDexecTest.class);
	}
}