// Module    : $RCSfile: ReplayReaderTest.java,v $
// Version   : $Revision: 0.0 $  $Author: Patrick $  $Date: 26.11.2011 15:10:08 $
// Project   : TaskTreePerformanceTest
// Creation  : 2011 by Patrick
// Copyright : Patrick Harms, 2011

package de.ugoe.cs.quest.plugin.mfc;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNotSame;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.quest.ReplayGenerator;
import de.ugoe.cs.quest.eventcore.Event;
import de.ugoe.cs.quest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.quest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.quest.plugin.mfc.guimodel.MFCGUIElement;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class MFCLogParserTest {

    /** */
    private File tmpFile;
    
    /**
     * 
     */
    @Before
    public void setUp() throws Exception {
        tmpFile = new File("tmp.xml");
        
        if (tmpFile.exists()) {
            assertTrue(tmpFile.delete());
        }
    }
    
    /**
     * 
     */
    @After
    public void tearDown() throws Exception {
        if (tmpFile.exists()) {
            assertTrue(tmpFile.delete());
        }
    }
    
    
    /**
     *
     */
    @Test
    public void testTrace() throws Exception {
        File traceFile = new File(ClassLoader.getSystemResource("trace.txt").getFile());
        
        new LogPreprocessor().convertToXml(traceFile.getAbsolutePath(),
                                           tmpFile.getAbsolutePath());
        
        MFCLogParser parser = new MFCLogParser();
        parser.parseFile(tmpFile);
        Collection<List<Event>> events = parser.getSequences();

        assertNotNull(events);
        assertTrue(events.size() > 0);

        System.err.println("{");
        for (List<Event> session : events) {
            System.err.println("  {");
            for (Event event : session) {
                System.err.print("    ");
                System.err.print(event);
                System.err.println(",");
            }
            System.err.println("  }");
        }
        System.err.println("}");
        System.err.println("\n\n");

        GUIModel guiModel = parser.getGuiModel();
        assertNotNull(guiModel);
        assertNotSame(0, guiModel.getRootElements().size());

        for (IGUIElement root : guiModel.getRootElements()) {
            dumpGUIElement(root, guiModel, "");
        }
    }

    /**
     *
     */
    @Test
    public void testLogfile() throws Exception {
        File logFile = new File(ClassLoader.getSystemResource("log.xml").getFile());

        MFCLogParser parser = new MFCLogParser();
        parser.parseFile(logFile);
        Collection<List<Event>> events = parser.getSequences();

        assertNotNull(events);
        assertTrue(events.size() > 0);

        System.err.println("{");
        for (List<Event> session : events) {
            System.err.println("  {");
            for (Event event : session) {
                System.err.print("    ");
                System.err.print(event);
                System.err.println(",");
            }
            System.err.println("  }");
        }
        System.err.println("}");
        System.err.println("\n\n");

        GUIModel guiModel = parser.getGuiModel();
        assertNotNull(guiModel);

        for (IGUIElement root : guiModel.getRootElements()) {
            dumpGUIElement(root, guiModel, "");
        }

        ReplayGenerator generator = new ReplayGenerator();
        generator.createLogfileMultipleSessions(parser.getSequences(), tmpFile.getAbsolutePath());
        
        InputStreamReader reader1 = 
            new InputStreamReader(ClassLoader.getSystemResourceAsStream("replay.xml"), "UTF-8");

        InputStreamReader reader2 = new InputStreamReader(new FileInputStream(tmpFile), "UTF-8");
        
        try {
            int sign1;
            do {
                sign1 = reader1.read();
                assertEquals(sign1, reader2.read());
            }
            while (sign1 > -1);
        }
        finally {
            reader1.close();
            reader2.close();
        }
    }

    /**
     * TODO: comment
     * 
     * @param root
     * @param guiModel
     */
    private void dumpGUIElement(IGUIElement guiElement, GUIModel guiModel, String indent) {
        assertTrue(guiElement instanceof MFCGUIElement);

        System.err.print(indent);
        System.err.print(guiElement);

        List<IGUIElement> children = guiModel.getChildren(guiElement);

        if ((children != null) && (children.size() > 0)) {
            System.err.println(" {");

            for (IGUIElement child : children) {
                dumpGUIElement(child, guiModel, indent + "  ");
            }

            System.err.print(indent);
            System.err.print("}");
        }

        System.err.println();
    }

}
