package de.ugoe.cs.eventbench.data;

import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.eventbench.IReplayDecorator;

public class ReplayableEvent<T extends IReplayable> extends Event<T> {

	private List<T> replayEvents = new LinkedList<T>();;

	private boolean replayValid = true;
	
	private IReplayDecorator decorator = null;
	
	public ReplayableEvent(String type) {
		super(type);
	}
	
	public void addReplaySequence(List<T> generatedReplaySeq) {
		replayEvents.addAll(generatedReplaySeq);
	}

	public void addReplayEvent(T replayable) {
		replayEvents.add(replayable);
	}
	
	/**
	 * <p>
	 * Returns a the list of replay events.
	 * </p> 
	 * <p>
	 * The return value is a copy of the list used internally!
	 * </p>
	 * @return list of replay events. 
	 */
	public List<T> getReplayMessages() {
		return new LinkedList<T>(replayEvents);
	}
	
	public boolean hasValidReplay() {
		return replayValid;
	}

	public void invalidateReplay() {
		replayValid = false;
	}

	public void setDecorator(IReplayDecorator decorator) {
		this.decorator = decorator;
	}
	
	public IReplayDecorator getReplayDecorator() {
		return decorator;
	}

}
