// Module    : $RCSfile: EqualityRule.java,v $
// Version   : $Revision: 0.0 $  $Author: patrick $  $Date: 19.02.2012 $
// Project   : TaskTreeCreator
// Creation  : 2012 by patrick
// Copyright : Patrick Harms, 2012

package de.ugoe.cs.quest.tasktrees.nodeequality;

import de.ugoe.cs.quest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * A node comparison rule is used by the {@link NodeEqualityRuleManager} to compare task tree
 * nodes with each other. It provides one method to be called for a comparison.
 * </p>
 * 
 * @version $Revision: $ $Date: 19.02.2012$
 * @author 2012, last modified by $Author: patrick$
 */
public interface NodeComparisonRule {

    /**
     * <p>
     * compares two nodes with each other. The result of the method is either a node equality or
     * null. If it is null, it means, that the rule is not able to correctly compare the two given
     * nodes
     * </p>
     * 
     * @param node1 the first task tree node to compare
     * @param node2 the second task tree node to compare
     * 
     * @return as described
     */
    public NodeEquality compare(ITaskTreeNode node1, ITaskTreeNode node2);

}
