/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree.analysis;

import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Value;

public class BasicVerifier
extends BasicInterpreter {
    public Value copyOperation(AbstractInsnNode abstractInsnNode, Value value) throws AnalyzerException {
        Value value2;
        switch (abstractInsnNode.getOpcode()) {
            case 21: 
            case 54: {
                value2 = BasicValue.INT_VALUE;
                break;
            }
            case 23: 
            case 56: {
                value2 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 22: 
            case 55: {
                value2 = BasicValue.LONG_VALUE;
                break;
            }
            case 24: 
            case 57: {
                value2 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 25: {
                if (!((BasicValue)value).isReference()) {
                    throw new AnalyzerException(abstractInsnNode, null, "an object reference", value);
                }
                return value;
            }
            case 58: {
                if (!((BasicValue)value).isReference() && !BasicValue.RETURNADDRESS_VALUE.equals(value)) {
                    throw new AnalyzerException(abstractInsnNode, null, "an object reference or a return address", value);
                }
                return value;
            }
            default: {
                return value;
            }
        }
        if (!value2.equals(value)) {
            throw new AnalyzerException(abstractInsnNode, null, value2, value);
        }
        return value;
    }

    public Value unaryOperation(AbstractInsnNode abstractInsnNode, Value value) throws AnalyzerException {
        Value value2;
        switch (abstractInsnNode.getOpcode()) {
            case 116: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 145: 
            case 146: 
            case 147: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 188: 
            case 189: {
                value2 = BasicValue.INT_VALUE;
                break;
            }
            case 118: 
            case 139: 
            case 140: 
            case 141: 
            case 174: {
                value2 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 117: 
            case 136: 
            case 137: 
            case 138: 
            case 173: {
                value2 = BasicValue.LONG_VALUE;
                break;
            }
            case 119: 
            case 142: 
            case 143: 
            case 144: 
            case 175: {
                value2 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 180: {
                value2 = this.newValue(Type.getObjectType((String)((FieldInsnNode)abstractInsnNode).owner));
                break;
            }
            case 192: {
                if (!((BasicValue)value).isReference()) {
                    throw new AnalyzerException(abstractInsnNode, null, "an object reference", value);
                }
                return super.unaryOperation(abstractInsnNode, value);
            }
            case 190: {
                if (!this.isArrayValue(value)) {
                    throw new AnalyzerException(abstractInsnNode, null, "an array reference", value);
                }
                return super.unaryOperation(abstractInsnNode, value);
            }
            case 176: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                if (!((BasicValue)value).isReference()) {
                    throw new AnalyzerException(abstractInsnNode, null, "an object reference", value);
                }
                return super.unaryOperation(abstractInsnNode, value);
            }
            case 179: {
                value2 = this.newValue(Type.getType((String)((FieldInsnNode)abstractInsnNode).desc));
                break;
            }
            default: {
                throw new Error("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value, value2)) {
            throw new AnalyzerException(abstractInsnNode, null, value2, value);
        }
        return super.unaryOperation(abstractInsnNode, value);
    }

    public Value binaryOperation(AbstractInsnNode abstractInsnNode, Value value, Value value2) throws AnalyzerException {
        Value value3;
        Value value4;
        switch (abstractInsnNode.getOpcode()) {
            case 46: {
                value4 = this.newValue(Type.getType((String)"[I"));
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 51: {
                value4 = this.isSubTypeOf(value, this.newValue(Type.getType((String)"[Z"))) ? this.newValue(Type.getType((String)"[Z")) : this.newValue(Type.getType((String)"[B"));
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 52: {
                value4 = this.newValue(Type.getType((String)"[C"));
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 53: {
                value4 = this.newValue(Type.getType((String)"[S"));
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 47: {
                value4 = this.newValue(Type.getType((String)"[J"));
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 48: {
                value4 = this.newValue(Type.getType((String)"[F"));
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 49: {
                value4 = this.newValue(Type.getType((String)"[D"));
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 50: {
                value4 = this.newValue(Type.getType((String)"[Ljava/lang/Object;"));
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                value4 = BasicValue.INT_VALUE;
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 149: 
            case 150: {
                value4 = BasicValue.FLOAT_VALUE;
                value3 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: 
            case 148: {
                value4 = BasicValue.LONG_VALUE;
                value3 = BasicValue.LONG_VALUE;
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                value4 = BasicValue.LONG_VALUE;
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 151: 
            case 152: {
                value4 = BasicValue.DOUBLE_VALUE;
                value3 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 165: 
            case 166: {
                value4 = BasicValue.REFERENCE_VALUE;
                value3 = BasicValue.REFERENCE_VALUE;
                break;
            }
            case 181: {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
                value4 = this.newValue(Type.getObjectType((String)fieldInsnNode.owner));
                value3 = this.newValue(Type.getType((String)fieldInsnNode.desc));
                break;
            }
            default: {
                throw new Error("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value, value4)) {
            throw new AnalyzerException(abstractInsnNode, "First argument", value4, value);
        }
        if (!this.isSubTypeOf(value2, value3)) {
            throw new AnalyzerException(abstractInsnNode, "Second argument", value3, value2);
        }
        if (abstractInsnNode.getOpcode() == 50) {
            return this.getElementValue(value);
        }
        return super.binaryOperation(abstractInsnNode, value, value2);
    }

    public Value ternaryOperation(AbstractInsnNode abstractInsnNode, Value value, Value value2, Value value3) throws AnalyzerException {
        Value value4;
        Value value5;
        switch (abstractInsnNode.getOpcode()) {
            case 79: {
                value5 = this.newValue(Type.getType((String)"[I"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 84: {
                value5 = this.isSubTypeOf(value, this.newValue(Type.getType((String)"[Z"))) ? this.newValue(Type.getType((String)"[Z")) : this.newValue(Type.getType((String)"[B"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 85: {
                value5 = this.newValue(Type.getType((String)"[C"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 86: {
                value5 = this.newValue(Type.getType((String)"[S"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 80: {
                value5 = this.newValue(Type.getType((String)"[J"));
                value4 = BasicValue.LONG_VALUE;
                break;
            }
            case 81: {
                value5 = this.newValue(Type.getType((String)"[F"));
                value4 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 82: {
                value5 = this.newValue(Type.getType((String)"[D"));
                value4 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 83: {
                value5 = value;
                value4 = BasicValue.REFERENCE_VALUE;
                break;
            }
            default: {
                throw new Error("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value, value5)) {
            throw new AnalyzerException(abstractInsnNode, "First argument", "a " + value5 + " array reference", value);
        }
        if (!BasicValue.INT_VALUE.equals(value2)) {
            throw new AnalyzerException(abstractInsnNode, "Second argument", BasicValue.INT_VALUE, value2);
        }
        if (!this.isSubTypeOf(value3, value4)) {
            throw new AnalyzerException(abstractInsnNode, "Third argument", value4, value3);
        }
        return null;
    }

    public Value naryOperation(AbstractInsnNode abstractInsnNode, List list) throws AnalyzerException {
        int n = abstractInsnNode.getOpcode();
        if (n == 197) {
            for (int i = 0; i < list.size(); ++i) {
                if (BasicValue.INT_VALUE.equals(list.get(i))) continue;
                throw new AnalyzerException(abstractInsnNode, null, BasicValue.INT_VALUE, (Value)list.get(i));
            }
        } else {
            Type type;
            int n2 = 0;
            int n3 = 0;
            if (n != 184 && n != 186) {
                type = Type.getObjectType((String)((MethodInsnNode)abstractInsnNode).owner);
                if (!this.isSubTypeOf((Value)list.get(n2++), this.newValue(type))) {
                    throw new AnalyzerException(abstractInsnNode, "Method owner", this.newValue(type), (Value)list.get(0));
                }
            }
            type = Type.getArgumentTypes((String)((MethodInsnNode)abstractInsnNode).desc);
            while (n2 < list.size()) {
                Value value;
                Value value2 = this.newValue(type[n3++]);
                if (this.isSubTypeOf(value = (Value)list.get(n2++), value2)) continue;
                throw new AnalyzerException(abstractInsnNode, "Argument " + n3, value2, value);
            }
        }
        return super.naryOperation(abstractInsnNode, list);
    }

    public void returnOperation(AbstractInsnNode abstractInsnNode, Value value, Value value2) throws AnalyzerException {
        if (!this.isSubTypeOf(value, value2)) {
            throw new AnalyzerException(abstractInsnNode, "Incompatible return type", value2, value);
        }
    }

    protected boolean isArrayValue(Value value) {
        return ((BasicValue)value).isReference();
    }

    protected Value getElementValue(Value value) throws AnalyzerException {
        return BasicValue.REFERENCE_VALUE;
    }

    protected boolean isSubTypeOf(Value value, Value value2) {
        return value.equals(value2);
    }
}

